/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.macie2;

import javax.annotation.Generated;

import com.amazonaws.services.macie2.model.*;
import com.amazonaws.*;
import com.amazonaws.services.macie2.waiters.AmazonMacie2Waiters;

/**
 * Abstract implementation of {@code AmazonMacie2}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonMacie2 implements AmazonMacie2 {

    protected AbstractAmazonMacie2() {
    }

    @Override
    public AcceptInvitationResult acceptInvitation(AcceptInvitationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchGetCustomDataIdentifiersResult batchGetCustomDataIdentifiers(BatchGetCustomDataIdentifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateAutomatedDiscoveryAccountsResult batchUpdateAutomatedDiscoveryAccounts(BatchUpdateAutomatedDiscoveryAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAllowListResult createAllowList(CreateAllowListRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateClassificationJobResult createClassificationJob(CreateClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateCustomDataIdentifierResult createCustomDataIdentifier(CreateCustomDataIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateFindingsFilterResult createFindingsFilter(CreateFindingsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInvitationsResult createInvitations(CreateInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMemberResult createMember(CreateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSampleFindingsResult createSampleFindings(CreateSampleFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeclineInvitationsResult declineInvitations(DeclineInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAllowListResult deleteAllowList(DeleteAllowListRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCustomDataIdentifierResult deleteCustomDataIdentifier(DeleteCustomDataIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFindingsFilterResult deleteFindingsFilter(DeleteFindingsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInvitationsResult deleteInvitations(DeleteInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMemberResult deleteMember(DeleteMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeBucketsResult describeBuckets(DescribeBucketsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeClassificationJobResult describeClassificationJob(DescribeClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationConfigurationResult describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableMacieResult disableMacie(DisableMacieRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisableOrganizationAdminAccountResult disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateFromAdministratorAccountResult disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateFromMasterAccountResult disassociateFromMasterAccount(DisassociateFromMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberResult disassociateMember(DisassociateMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableMacieResult enableMacie(EnableMacieRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public EnableOrganizationAdminAccountResult enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAdministratorAccountResult getAdministratorAccount(GetAdministratorAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAllowListResult getAllowList(GetAllowListRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAutomatedDiscoveryConfigurationResult getAutomatedDiscoveryConfiguration(GetAutomatedDiscoveryConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetBucketStatisticsResult getBucketStatistics(GetBucketStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetClassificationExportConfigurationResult getClassificationExportConfiguration(GetClassificationExportConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetClassificationScopeResult getClassificationScope(GetClassificationScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCustomDataIdentifierResult getCustomDataIdentifier(GetCustomDataIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingStatisticsResult getFindingStatistics(GetFindingStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsResult getFindings(GetFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsFilterResult getFindingsFilter(GetFindingsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetFindingsPublicationConfigurationResult getFindingsPublicationConfiguration(GetFindingsPublicationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInvitationsCountResult getInvitationsCount(GetInvitationsCountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMacieSessionResult getMacieSession(GetMacieSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMasterAccountResult getMasterAccount(GetMasterAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMemberResult getMember(GetMemberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetResourceProfileResult getResourceProfile(GetResourceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRevealConfigurationResult getRevealConfiguration(GetRevealConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSensitiveDataOccurrencesResult getSensitiveDataOccurrences(GetSensitiveDataOccurrencesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSensitiveDataOccurrencesAvailabilityResult getSensitiveDataOccurrencesAvailability(GetSensitiveDataOccurrencesAvailabilityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSensitivityInspectionTemplateResult getSensitivityInspectionTemplate(GetSensitivityInspectionTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUsageStatisticsResult getUsageStatistics(GetUsageStatisticsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUsageTotalsResult getUsageTotals(GetUsageTotalsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAllowListsResult listAllowLists(ListAllowListsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAutomatedDiscoveryAccountsResult listAutomatedDiscoveryAccounts(ListAutomatedDiscoveryAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClassificationJobsResult listClassificationJobs(ListClassificationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListClassificationScopesResult listClassificationScopes(ListClassificationScopesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomDataIdentifiersResult listCustomDataIdentifiers(ListCustomDataIdentifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingsResult listFindings(ListFindingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListFindingsFiltersResult listFindingsFilters(ListFindingsFiltersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInvitationsResult listInvitations(ListInvitationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListManagedDataIdentifiersResult listManagedDataIdentifiers(ListManagedDataIdentifiersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMembersResult listMembers(ListMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationAdminAccountsResult listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceProfileArtifactsResult listResourceProfileArtifacts(ListResourceProfileArtifactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceProfileDetectionsResult listResourceProfileDetections(ListResourceProfileDetectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSensitivityInspectionTemplatesResult listSensitivityInspectionTemplates(ListSensitivityInspectionTemplatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutClassificationExportConfigurationResult putClassificationExportConfiguration(PutClassificationExportConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutFindingsPublicationConfigurationResult putFindingsPublicationConfiguration(PutFindingsPublicationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchResourcesResult searchResources(SearchResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestCustomDataIdentifierResult testCustomDataIdentifier(TestCustomDataIdentifierRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAllowListResult updateAllowList(UpdateAllowListRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAutomatedDiscoveryConfigurationResult updateAutomatedDiscoveryConfiguration(UpdateAutomatedDiscoveryConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClassificationJobResult updateClassificationJob(UpdateClassificationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateClassificationScopeResult updateClassificationScope(UpdateClassificationScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateFindingsFilterResult updateFindingsFilter(UpdateFindingsFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMacieSessionResult updateMacieSession(UpdateMacieSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMemberSessionResult updateMemberSession(UpdateMemberSessionRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateOrganizationConfigurationResult updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceProfileResult updateResourceProfile(UpdateResourceProfileRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceProfileDetectionsResult updateResourceProfileDetections(UpdateResourceProfileDetectionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRevealConfigurationResult updateRevealConfiguration(UpdateRevealConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSensitivityInspectionTemplateResult updateSensitivityInspectionTemplate(UpdateSensitivityInspectionTemplateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AmazonMacie2Waiters waiters() {
        throw new java.lang.UnsupportedOperationException();
    }

}
