/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iottwinmaker;

import javax.annotation.Generated;

import com.amazonaws.services.iottwinmaker.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSIoTTwinMaker}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTTwinMaker implements AWSIoTTwinMaker {

    protected AbstractAWSIoTTwinMaker() {
    }

    @Override
    public BatchPutPropertyValuesResult batchPutPropertyValues(BatchPutPropertyValuesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMetadataTransferJobResult cancelMetadataTransferJob(CancelMetadataTransferJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateComponentTypeResult createComponentType(CreateComponentTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateEntityResult createEntity(CreateEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMetadataTransferJobResult createMetadataTransferJob(CreateMetadataTransferJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSceneResult createScene(CreateSceneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateSyncJobResult createSyncJob(CreateSyncJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWorkspaceResult createWorkspace(CreateWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteComponentTypeResult deleteComponentType(DeleteComponentTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEntityResult deleteEntity(DeleteEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSceneResult deleteScene(DeleteSceneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteSyncJobResult deleteSyncJob(DeleteSyncJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWorkspaceResult deleteWorkspace(DeleteWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ExecuteQueryResult executeQuery(ExecuteQueryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetComponentTypeResult getComponentType(GetComponentTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetEntityResult getEntity(GetEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMetadataTransferJobResult getMetadataTransferJob(GetMetadataTransferJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPricingPlanResult getPricingPlan(GetPricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPropertyValueResult getPropertyValue(GetPropertyValueRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPropertyValueHistoryResult getPropertyValueHistory(GetPropertyValueHistoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSceneResult getScene(GetSceneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSyncJobResult getSyncJob(GetSyncJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWorkspaceResult getWorkspace(GetWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentTypesResult listComponentTypes(ListComponentTypesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEntitiesResult listEntities(ListEntitiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMetadataTransferJobsResult listMetadataTransferJobs(ListMetadataTransferJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPropertiesResult listProperties(ListPropertiesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListScenesResult listScenes(ListScenesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSyncJobsResult listSyncJobs(ListSyncJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListSyncResourcesResult listSyncResources(ListSyncResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWorkspacesResult listWorkspaces(ListWorkspacesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateComponentTypeResult updateComponentType(UpdateComponentTypeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateEntityResult updateEntity(UpdateEntityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePricingPlanResult updatePricingPlan(UpdatePricingPlanRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateSceneResult updateScene(UpdateSceneRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWorkspaceResult updateWorkspace(UpdateWorkspaceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
