/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotsitewise;

import javax.annotation.Generated;

import com.amazonaws.*;
import com.amazonaws.regions.*;

import com.amazonaws.services.iotsitewise.model.*;
import com.amazonaws.services.iotsitewise.waiters.AWSIoTSiteWiseWaiters;

/**
 * Interface for accessing AWS IoT SiteWise.
 * <p>
 * <b>Note:</b> Do not directly implement this interface, new methods are added to it regularly. Extend from
 * {@link com.amazonaws.services.iotsitewise.AbstractAWSIoTSiteWise} instead.
 * </p>
 * <p>
 * <p>
 * Welcome to the IoT SiteWise API Reference. IoT SiteWise is an Amazon Web Services service that connects <a
 * href="https://en.wikipedia.org/wiki/Internet_of_things#Industrial_applications">Industrial Internet of Things
 * (IIoT)</a> devices to the power of the Amazon Web Services Cloud. For more information, see the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/">IoT SiteWise User Guide</a>. For information about
 * IoT SiteWise quotas, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a>
 * in the <i>IoT SiteWise User Guide</i>.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public interface AWSIoTSiteWise {

    /**
     * The region metadata service name for computing region endpoints. You can use this value to retrieve metadata
     * (such as supported regions) of the service.
     *
     * @see RegionUtils#getRegionsForService(String)
     */
    String ENDPOINT_PREFIX = "iotsitewise";

    /**
     * <p>
     * Associates a child asset with the given parent asset through a hierarchy defined in the parent asset's model. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/add-associated-assets.html">Associating
     * assets</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param associateAssetsRequest
     * @return Result of the AssociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.AssociateAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    AssociateAssetsResult associateAssets(AssociateAssetsRequest associateAssetsRequest);

    /**
     * <p>
     * Associates a time series (data stream) with an asset property.
     * </p>
     * 
     * @param associateTimeSeriesToAssetPropertyRequest
     * @return Result of the AssociateTimeSeriesToAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.AssociateTimeSeriesToAssetProperty
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/AssociateTimeSeriesToAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    AssociateTimeSeriesToAssetPropertyResult associateTimeSeriesToAssetProperty(
            AssociateTimeSeriesToAssetPropertyRequest associateTimeSeriesToAssetPropertyRequest);

    /**
     * <p>
     * Associates a group (batch) of assets with an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param batchAssociateProjectAssetsRequest
     * @return Result of the BatchAssociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.BatchAssociateProjectAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchAssociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    BatchAssociateProjectAssetsResult batchAssociateProjectAssets(BatchAssociateProjectAssetsRequest batchAssociateProjectAssetsRequest);

    /**
     * <p>
     * Disassociates a group (batch) of assets from an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param batchDisassociateProjectAssetsRequest
     * @return Result of the BatchDisassociateProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.BatchDisassociateProjectAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchDisassociateProjectAssets"
     *      target="_top">AWS API Documentation</a>
     */
    BatchDisassociateProjectAssetsResult batchDisassociateProjectAssets(BatchDisassociateProjectAssetsRequest batchDisassociateProjectAssetsRequest);

    /**
     * <p>
     * Gets aggregated values (for example, average, minimum, and maximum) for one or more asset properties. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param batchGetAssetPropertyAggregatesRequest
     * @return Result of the BatchGetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.BatchGetAssetPropertyAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    BatchGetAssetPropertyAggregatesResult batchGetAssetPropertyAggregates(BatchGetAssetPropertyAggregatesRequest batchGetAssetPropertyAggregatesRequest);

    /**
     * <p>
     * Gets the current value for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param batchGetAssetPropertyValueRequest
     * @return Result of the BatchGetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.BatchGetAssetPropertyValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    BatchGetAssetPropertyValueResult batchGetAssetPropertyValue(BatchGetAssetPropertyValueRequest batchGetAssetPropertyValueRequest);

    /**
     * <p>
     * Gets the historical values for one or more asset properties. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param batchGetAssetPropertyValueHistoryRequest
     * @return Result of the BatchGetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.BatchGetAssetPropertyValueHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchGetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    BatchGetAssetPropertyValueHistoryResult batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryRequest batchGetAssetPropertyValueHistoryRequest);

    /**
     * <p>
     * Sends a list of asset property values to IoT SiteWise. Each value is a timestamp-quality-value (TQV) data point.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ingest-api.html">Ingesting data using the API</a>
     * in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * With respect to Unix epoch time, IoT SiteWise accepts only TQVs that have a timestamp of no more than 7 days in
     * the past and no more than 10 minutes in the future. IoT SiteWise rejects timestamps outside of the inclusive
     * range of [-7 days, +10 minutes] and returns a <code>TimestampOutOfRangeException</code> error.
     * </p>
     * <p>
     * For each asset property, IoT SiteWise overwrites TQVs with duplicate timestamps unless the newer TQV has a
     * different quality. For example, if you store a TQV <code>{T1, GOOD, V1}</code>, then storing
     * <code>{T1, GOOD, V2}</code> replaces the existing TQV.
     * </p>
     * </important>
     * <p>
     * IoT SiteWise authorizes access to each <code>BatchPutAssetPropertyValue</code> entry individually. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-batchputassetpropertyvalue-action"
     * >BatchPutAssetPropertyValue authorization</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param batchPutAssetPropertyValueRequest
     * @return Result of the BatchPutAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.BatchPutAssetPropertyValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/BatchPutAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    BatchPutAssetPropertyValueResult batchPutAssetPropertyValue(BatchPutAssetPropertyValueRequest batchPutAssetPropertyValueRequest);

    /**
     * <p>
     * Creates an access policy that grants the specified identity (IAM Identity Center user, IAM Identity Center group,
     * or IAM user) access to the specified IoT SiteWise Monitor portal or project resource.
     * </p>
     * 
     * @param createAccessPolicyRequest
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreateAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    CreateAccessPolicyResult createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest);

    /**
     * <p>
     * Creates an asset from an existing asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-assets.html">Creating assets</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param createAssetRequest
     * @return Result of the CreateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.CreateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    CreateAssetResult createAsset(CreateAssetRequest createAssetRequest);

    /**
     * <p>
     * Creates an asset model from specified property and hierarchy definitions. You create assets from asset models.
     * With asset models, you can easily create assets of the same type that have standardized definitions. Each asset
     * created from a model inherits the asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/define-models.html">Defining asset models</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can create two types of asset models, <code>ASSET_MODEL</code> or <code>COMPONENT_MODEL</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ASSET_MODEL</b> – (default) An asset model that you can use to create assets. Can't be included as a component
     * in another asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>COMPONENT_MODEL</b> – A reusable component that you can include in the composite models of other asset models.
     * You can't create assets directly from this type of asset model.
     * </p>
     * </li>
     * </ul>
     * 
     * @param createAssetModelRequest
     * @return Result of the CreateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.CreateAssetModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    CreateAssetModelResult createAssetModel(CreateAssetModelRequest createAssetModelRequest);

    /**
     * <p>
     * Creates a custom composite model from specified property and hierarchy definitions. There are two types of custom
     * composite models, <code>inline</code> and <code>component-model-based</code>.
     * </p>
     * <p>
     * Use component-model-based custom composite models to define standard, reusable components. A
     * component-model-based custom composite model consists of a name, a description, and the ID of the component model
     * it references. A component-model-based custom composite model has no properties of its own; its referenced
     * component model provides its associated properties to any created assets. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Use inline custom composite models to organize the properties of an asset model. The properties of inline custom
     * composite models are local to the asset model where they are included and can't be used to create multiple
     * assets.
     * </p>
     * <p>
     * To create a component-model-based model, specify the <code>composedAssetModelId</code> of an existing asset model
     * with <code>assetModelType</code> of <code>COMPONENT_MODEL</code>.
     * </p>
     * <p>
     * To create an inline model, specify the <code>assetModelCompositeModelProperties</code> and don't include an
     * <code>composedAssetModelId</code>.
     * </p>
     * 
     * @param createAssetModelCompositeModelRequest
     * @return Result of the CreateAssetModelCompositeModel operation returned by the service.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreateAssetModelCompositeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    CreateAssetModelCompositeModelResult createAssetModelCompositeModel(CreateAssetModelCompositeModelRequest createAssetModelCompositeModelRequest);

    /**
     * <p>
     * Defines a job to ingest data to IoT SiteWise from Amazon S3. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/CreateBulkImportJob.html">Create a bulk import
     * job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * <important>
     * <p>
     * Before you create a bulk import job, you must enable IoT SiteWise warm tier or IoT SiteWise cold tier. For more
     * information about how to configure storage settings, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_PutStorageConfiguration.html"
     * >PutStorageConfiguration</a>.
     * </p>
     * <p>
     * Bulk import is designed to store historical data to IoT SiteWise. It does not trigger computations or
     * notifications on IoT SiteWise warm or cold tier storage.
     * </p>
     * </important>
     * 
     * @param createBulkImportJobRequest
     * @return Result of the CreateBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.CreateBulkImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    CreateBulkImportJobResult createBulkImportJob(CreateBulkImportJobRequest createBulkImportJobRequest);

    /**
     * <p>
     * Creates a dashboard in an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    CreateDashboardResult createDashboard(CreateDashboardRequest createDashboardRequest);

    /**
     * <p>
     * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to
     * IoT SiteWise. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a
     * gateway</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param createGatewayRequest
     * @return Result of the CreateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    CreateGatewayResult createGateway(CreateGatewayRequest createGatewayRequest);

    /**
     * <p>
     * Creates a portal, which can contain projects and dashboards. IoT SiteWise Monitor uses IAM Identity Center or IAM
     * to authenticate portal users and manage user permissions.
     * </p>
     * <note>
     * <p>
     * Before you can sign in to a new portal, you must add at least one identity to that portal. For more information,
     * see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/administer-portals.html#portal-change-admins"
     * >Adding or removing portal administrators</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     * 
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreatePortal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    CreatePortalResult createPortal(CreatePortalRequest createPortalRequest);

    /**
     * <p>
     * Creates a project in the specified portal.
     * </p>
     * <note>
     * <p>
     * Make sure that the project name and description don't contain confidential information.
     * </p>
     * </note>
     * 
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.CreateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/CreateProject" target="_top">AWS API
     *      Documentation</a>
     */
    CreateProjectResult createProject(CreateProjectRequest createProjectRequest);

    /**
     * <p>
     * Deletes an access policy that grants the specified identity access to the specified IoT SiteWise Monitor
     * resource. You can use this operation to revoke access to an IoT SiteWise Monitor resource.
     * </p>
     * 
     * @param deleteAccessPolicyRequest
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DeleteAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteAccessPolicyResult deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest);

    /**
     * <p>
     * Deletes an asset. This action can't be undone. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't delete an asset that's associated to another asset. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DisassociateAssets.html"
     * >DisassociateAssets</a>.
     * </p>
     * </note>
     * 
     * @param deleteAssetRequest
     * @return Result of the DeleteAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DeleteAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAsset" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteAssetResult deleteAsset(DeleteAssetRequest deleteAssetRequest);

    /**
     * <p>
     * Deletes an asset model. This action can't be undone. You must delete all assets created from an asset model
     * before you can delete the model. Also, you can't delete an asset model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param deleteAssetModelRequest
     * @return Result of the DeleteAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DeleteAssetModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteAssetModelResult deleteAssetModel(DeleteAssetModelRequest deleteAssetModelRequest);

    /**
     * <p>
     * Deletes a composite model. This action can't be undone. You must delete all assets created from a composite model
     * before you can delete the model. Also, you can't delete a composite model if a parent asset model exists that
     * contains a property formula expression that depends on the asset model that you want to delete. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/delete-assets-and-models.html">Deleting assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param deleteAssetModelCompositeModelRequest
     * @return Result of the DeleteAssetModelCompositeModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DeleteAssetModelCompositeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    DeleteAssetModelCompositeModelResult deleteAssetModelCompositeModel(DeleteAssetModelCompositeModelRequest deleteAssetModelCompositeModelRequest);

    /**
     * <p>
     * Deletes a dashboard from IoT SiteWise Monitor.
     * </p>
     * 
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DeleteDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteDashboardResult deleteDashboard(DeleteDashboardRequest deleteDashboardRequest);

    /**
     * <p>
     * Deletes a gateway from IoT SiteWise. When you delete a gateway, some of the gateway's files remain in your
     * gateway's file system.
     * </p>
     * 
     * @param deleteGatewayRequest
     * @return Result of the DeleteGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DeleteGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteGateway" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteGatewayResult deleteGateway(DeleteGatewayRequest deleteGatewayRequest);

    /**
     * <p>
     * Deletes a portal from IoT SiteWise Monitor.
     * </p>
     * 
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DeletePortal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeletePortal" target="_top">AWS API
     *      Documentation</a>
     */
    DeletePortalResult deletePortal(DeletePortalRequest deletePortalRequest);

    /**
     * <p>
     * Deletes a project from IoT SiteWise Monitor.
     * </p>
     * 
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DeleteProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteProject" target="_top">AWS API
     *      Documentation</a>
     */
    DeleteProjectResult deleteProject(DeleteProjectRequest deleteProjectRequest);

    /**
     * <p>
     * Deletes a time series (data stream). If you delete a time series that's associated with an asset property, the
     * asset property still exists, but the time series will no longer be associated with this asset property.
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @param deleteTimeSeriesRequest
     * @return Result of the DeleteTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DeleteTimeSeries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DeleteTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    DeleteTimeSeriesResult deleteTimeSeries(DeleteTimeSeriesRequest deleteTimeSeriesRequest);

    /**
     * <p>
     * Describes an access policy, which specifies an identity's access to an IoT SiteWise Monitor portal or project.
     * </p>
     * 
     * @param describeAccessPolicyRequest
     * @return Result of the DescribeAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeAccessPolicyResult describeAccessPolicy(DescribeAccessPolicyRequest describeAccessPolicyRequest);

    /**
     * <p>
     * Retrieves information about an action.
     * </p>
     * 
     * @param describeActionRequest
     * @return Result of the DescribeAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAction" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeActionResult describeAction(DescribeActionRequest describeActionRequest);

    /**
     * <p>
     * Retrieves information about an asset.
     * </p>
     * 
     * @param describeAssetRequest
     * @return Result of the DescribeAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAsset" target="_top">AWS API
     *      Documentation</a>
     */
    DescribeAssetResult describeAsset(DescribeAssetRequest describeAssetRequest);

    /**
     * <p>
     * Retrieves information about an asset composite model (also known as an asset component). An
     * <code>AssetCompositeModel</code> is an instance of an <code>AssetModelCompositeModel</code>. If you want to see
     * information about the model this is based on, call <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetModelCompositeModel.html"
     * >DescribeAssetModelCompositeModel</a>.
     * </p>
     * 
     * @param describeAssetCompositeModelRequest
     * @return Result of the DescribeAssetCompositeModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAssetCompositeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeAssetCompositeModelResult describeAssetCompositeModel(DescribeAssetCompositeModelRequest describeAssetCompositeModelRequest);

    /**
     * <p>
     * Retrieves information about an asset model.
     * </p>
     * 
     * @param describeAssetModelRequest
     * @return Result of the DescribeAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAssetModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeAssetModelResult describeAssetModel(DescribeAssetModelRequest describeAssetModelRequest);

    /**
     * <p>
     * Retrieves information about an asset model composite model (also known as an asset model component). For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/custom-composite-models.html">Custom composite
     * models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param describeAssetModelCompositeModelRequest
     * @return Result of the DescribeAssetModelCompositeModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAssetModelCompositeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeAssetModelCompositeModelResult describeAssetModelCompositeModel(DescribeAssetModelCompositeModelRequest describeAssetModelCompositeModelRequest);

    /**
     * <p>
     * Retrieves information about an asset property.
     * </p>
     * <note>
     * <p>
     * When you call this operation for an attribute property, this response includes the default attribute value that
     * you define in the asset model. If you update the default value in the model, this operation's response includes
     * the new default value.
     * </p>
     * </note>
     * <p>
     * This operation doesn't return the value of the asset property. To get the value of an asset property, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_GetAssetPropertyValue.html">
     * GetAssetPropertyValue</a>.
     * </p>
     * 
     * @param describeAssetPropertyRequest
     * @return Result of the DescribeAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeAssetProperty
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeAssetPropertyResult describeAssetProperty(DescribeAssetPropertyRequest describeAssetPropertyRequest);

    /**
     * <p>
     * Retrieves information about a bulk import job request. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/DescribeBulkImportJob.html">Describe a bulk
     * import job (CLI)</a> in the <i>Amazon Simple Storage Service User Guide</i>.
     * </p>
     * 
     * @param describeBulkImportJobRequest
     * @return Result of the DescribeBulkImportJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeBulkImportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeBulkImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeBulkImportJobResult describeBulkImportJob(DescribeBulkImportJobRequest describeBulkImportJobRequest);

    /**
     * <p>
     * Retrieves information about a dashboard.
     * </p>
     * 
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeDashboardResult describeDashboard(DescribeDashboardRequest describeDashboardRequest);

    /**
     * <p>
     * Retrieves information about the default encryption configuration for the Amazon Web Services account in the
     * default or specified Region. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param describeDefaultEncryptionConfigurationRequest
     * @return Result of the DescribeDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeDefaultEncryptionConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeDefaultEncryptionConfigurationResult describeDefaultEncryptionConfiguration(
            DescribeDefaultEncryptionConfigurationRequest describeDefaultEncryptionConfigurationRequest);

    /**
     * <p>
     * Retrieves information about a gateway.
     * </p>
     * 
     * @param describeGatewayRequest
     * @return Result of the DescribeGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGateway" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeGatewayResult describeGateway(DescribeGatewayRequest describeGatewayRequest);

    /**
     * <p>
     * Retrieves information about a gateway capability configuration. Each gateway capability defines data sources for
     * a gateway. A capability configuration can contain multiple data source configurations. If you define OPC-UA
     * sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in one capability
     * configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * 
     * @param describeGatewayCapabilityConfigurationRequest
     * @return Result of the DescribeGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeGatewayCapabilityConfiguration
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeGatewayCapabilityConfigurationResult describeGatewayCapabilityConfiguration(
            DescribeGatewayCapabilityConfigurationRequest describeGatewayCapabilityConfigurationRequest);

    /**
     * <p>
     * Retrieves the current IoT SiteWise logging options.
     * </p>
     * 
     * @param describeLoggingOptionsRequest
     * @return Result of the DescribeLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @sample AWSIoTSiteWise.DescribeLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeLoggingOptions"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeLoggingOptionsResult describeLoggingOptions(DescribeLoggingOptionsRequest describeLoggingOptionsRequest);

    /**
     * <p>
     * Retrieves information about a portal.
     * </p>
     * 
     * @param describePortalRequest
     * @return Result of the DescribePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribePortal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribePortal" target="_top">AWS API
     *      Documentation</a>
     */
    DescribePortalResult describePortal(DescribePortalRequest describePortalRequest);

    /**
     * <p>
     * Retrieves information about a project.
     * </p>
     * 
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeProject" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeProjectResult describeProject(DescribeProjectRequest describeProjectRequest);

    /**
     * <p>
     * Retrieves information about the storage configuration for IoT SiteWise.
     * </p>
     * 
     * @param describeStorageConfigurationRequest
     * @return Result of the DescribeStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DescribeStorageConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    DescribeStorageConfigurationResult describeStorageConfiguration(DescribeStorageConfigurationRequest describeStorageConfigurationRequest);

    /**
     * <p>
     * Retrieves information about a time series (data stream).
     * </p>
     * <p>
     * To identify a time series, do one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the time series isn't associated with an asset property, specify the <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the time series is associated with an asset property, specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>alias</code> of the time series.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> that identifies the asset property.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @param describeTimeSeriesRequest
     * @return Result of the DescribeTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.DescribeTimeSeries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DescribeTimeSeries" target="_top">AWS
     *      API Documentation</a>
     */
    DescribeTimeSeriesResult describeTimeSeries(DescribeTimeSeriesRequest describeTimeSeriesRequest);

    /**
     * <p>
     * Disassociates a child asset from the given parent asset through a hierarchy defined in the parent asset's model.
     * </p>
     * 
     * @param disassociateAssetsRequest
     * @return Result of the DisassociateAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DisassociateAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateAssets" target="_top">AWS
     *      API Documentation</a>
     */
    DisassociateAssetsResult disassociateAssets(DisassociateAssetsRequest disassociateAssetsRequest);

    /**
     * <p>
     * Disassociates a time series (data stream) from an asset property.
     * </p>
     * 
     * @param disassociateTimeSeriesFromAssetPropertyRequest
     * @return Result of the DisassociateTimeSeriesFromAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.DisassociateTimeSeriesFromAssetProperty
     * @see <a
     *      href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/DisassociateTimeSeriesFromAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    DisassociateTimeSeriesFromAssetPropertyResult disassociateTimeSeriesFromAssetProperty(
            DisassociateTimeSeriesFromAssetPropertyRequest disassociateTimeSeriesFromAssetPropertyRequest);

    /**
     * <p>
     * Executes an action on a target resource.
     * </p>
     * 
     * @param executeActionRequest
     * @return Result of the ExecuteAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.ExecuteAction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteAction" target="_top">AWS API
     *      Documentation</a>
     */
    ExecuteActionResult executeAction(ExecuteActionRequest executeActionRequest);

    /**
     * <p>
     * Run SQL queries to retrieve metadata and time-series data from asset models, assets, measurements, metrics,
     * transforms, and aggregates.
     * </p>
     * 
     * @param executeQueryRequest
     * @return Result of the ExecuteQuery operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ValidationException
     *         The validation failed for this query.
     * @throws QueryTimeoutException
     *         The query timed out.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.ExecuteQuery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ExecuteQuery" target="_top">AWS API
     *      Documentation</a>
     */
    ExecuteQueryResult executeQuery(ExecuteQueryRequest executeQueryRequest);

    /**
     * <p>
     * Gets aggregated values for an asset property. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#aggregates">Querying
     * aggregates</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param getAssetPropertyAggregatesRequest
     * @return Result of the GetAssetPropertyAggregates operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.GetAssetPropertyAggregates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyAggregates"
     *      target="_top">AWS API Documentation</a>
     */
    GetAssetPropertyAggregatesResult getAssetPropertyAggregates(GetAssetPropertyAggregatesRequest getAssetPropertyAggregatesRequest);

    /**
     * <p>
     * Gets an asset property's current value. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#current-values"
     * >Querying current values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param getAssetPropertyValueRequest
     * @return Result of the GetAssetPropertyValue operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.GetAssetPropertyValue
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValue"
     *      target="_top">AWS API Documentation</a>
     */
    GetAssetPropertyValueResult getAssetPropertyValue(GetAssetPropertyValueRequest getAssetPropertyValueRequest);

    /**
     * <p>
     * Gets the history of an asset property's values. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/query-industrial-data.html#historical-values"
     * >Querying historical values</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param getAssetPropertyValueHistoryRequest
     * @return Result of the GetAssetPropertyValueHistory operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.GetAssetPropertyValueHistory
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetAssetPropertyValueHistory"
     *      target="_top">AWS API Documentation</a>
     */
    GetAssetPropertyValueHistoryResult getAssetPropertyValueHistory(GetAssetPropertyValueHistoryRequest getAssetPropertyValueHistoryRequest);

    /**
     * <p>
     * Get interpolated values for an asset property for a specified time interval, during a period of time. If your
     * time series is missing data points during the specified time interval, you can use interpolation to estimate the
     * missing data.
     * </p>
     * <p>
     * For example, you can use this operation to return the interpolated temperature values for a wind turbine every 24
     * hours over a duration of 7 days.
     * </p>
     * <p>
     * To identify an asset property, you must specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The <code>assetId</code> and <code>propertyId</code> of an asset property.
     * </p>
     * </li>
     * <li>
     * <p>
     * A <code>propertyAlias</code>, which is a data stream alias (for example,
     * <code>/company/windfarm/3/turbine/7/temperature</code>). To define an asset property's alias, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html"
     * >UpdateAssetProperty</a>.
     * </p>
     * </li>
     * </ul>
     * 
     * @param getInterpolatedAssetPropertyValuesRequest
     * @return Result of the GetInterpolatedAssetPropertyValues operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ServiceUnavailableException
     *         The requested service is unavailable.
     * @sample AWSIoTSiteWise.GetInterpolatedAssetPropertyValues
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/GetInterpolatedAssetPropertyValues"
     *      target="_top">AWS API Documentation</a>
     */
    GetInterpolatedAssetPropertyValuesResult getInterpolatedAssetPropertyValues(
            GetInterpolatedAssetPropertyValuesRequest getInterpolatedAssetPropertyValuesRequest);

    /**
     * <p>
     * Retrieves a paginated list of access policies for an identity (an IAM Identity Center user, an IAM Identity
     * Center group, or an IAM user) or an IoT SiteWise Monitor resource (a portal or project).
     * </p>
     * 
     * @param listAccessPoliciesRequest
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAccessPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAccessPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    ListAccessPoliciesResult listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest);

    /**
     * <p>
     * Retrieves a paginated list of actions for a specific target resource.
     * </p>
     * 
     * @param listActionsRequest
     * @return Result of the ListActions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListActions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListActions" target="_top">AWS API
     *      Documentation</a>
     */
    ListActionsResult listActions(ListActionsRequest listActionsRequest);

    /**
     * <p>
     * Retrieves a paginated list of composite models associated with the asset model
     * </p>
     * 
     * @param listAssetModelCompositeModelsRequest
     * @return Result of the ListAssetModelCompositeModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @sample AWSIoTSiteWise.ListAssetModelCompositeModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelCompositeModels"
     *      target="_top">AWS API Documentation</a>
     */
    ListAssetModelCompositeModelsResult listAssetModelCompositeModels(ListAssetModelCompositeModelsRequest listAssetModelCompositeModelsRequest);

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset model. If you update properties associated with
     * the model before you finish listing all the properties, you need to start all over again.
     * </p>
     * 
     * @param listAssetModelPropertiesRequest
     * @return Result of the ListAssetModelProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssetModelProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModelProperties"
     *      target="_top">AWS API Documentation</a>
     */
    ListAssetModelPropertiesResult listAssetModelProperties(ListAssetModelPropertiesRequest listAssetModelPropertiesRequest);

    /**
     * <p>
     * Retrieves a paginated list of summaries of all asset models.
     * </p>
     * 
     * @param listAssetModelsRequest
     * @return Result of the ListAssetModels operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssetModels
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetModels" target="_top">AWS
     *      API Documentation</a>
     */
    ListAssetModelsResult listAssetModels(ListAssetModelsRequest listAssetModelsRequest);

    /**
     * <p>
     * Retrieves a paginated list of properties associated with an asset. If you update properties associated with the
     * model before you finish listing all the properties, you need to start all over again.
     * </p>
     * 
     * @param listAssetPropertiesRequest
     * @return Result of the ListAssetProperties operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssetProperties
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetProperties"
     *      target="_top">AWS API Documentation</a>
     */
    ListAssetPropertiesResult listAssetProperties(ListAssetPropertiesRequest listAssetPropertiesRequest);

    /**
     * <p>
     * Retrieves a paginated list of asset relationships for an asset. You can use this operation to identify an asset's
     * root asset and all associated assets between that asset and its root.
     * </p>
     * 
     * @param listAssetRelationshipsRequest
     * @return Result of the ListAssetRelationships operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssetRelationships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssetRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    ListAssetRelationshipsResult listAssetRelationships(ListAssetRelationshipsRequest listAssetRelationshipsRequest);

    /**
     * <p>
     * Retrieves a paginated list of asset summaries.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List assets based on a specific asset model.
     * </p>
     * </li>
     * <li>
     * <p>
     * List top-level assets.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can't use this operation to list all assets. To retrieve summaries for all of your assets, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_ListAssetModels.html">ListAssetModels</a>
     * to get all of your asset model IDs. Then, use ListAssets to get all assets for each asset model.
     * </p>
     * 
     * @param listAssetsRequest
     * @return Result of the ListAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssets" target="_top">AWS API
     *      Documentation</a>
     */
    ListAssetsResult listAssets(ListAssetsRequest listAssetsRequest);

    /**
     * <p>
     * Retrieves a paginated list of associated assets.
     * </p>
     * <p>
     * You can use this operation to do the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * List child assets associated to a parent asset by a hierarchy that you specify.
     * </p>
     * </li>
     * <li>
     * <p>
     * List an asset's parent asset.
     * </p>
     * </li>
     * </ul>
     * 
     * @param listAssociatedAssetsRequest
     * @return Result of the ListAssociatedAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListAssociatedAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListAssociatedAssets"
     *      target="_top">AWS API Documentation</a>
     */
    ListAssociatedAssetsResult listAssociatedAssets(ListAssociatedAssetsRequest listAssociatedAssetsRequest);

    /**
     * <p>
     * Retrieves a paginated list of bulk import job requests. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/ListBulkImportJobs.html">List bulk import jobs
     * (CLI)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param listBulkImportJobsRequest
     * @return Result of the ListBulkImportJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListBulkImportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListBulkImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    ListBulkImportJobsResult listBulkImportJobs(ListBulkImportJobsRequest listBulkImportJobsRequest);

    /**
     * <p>
     * Retrieves a paginated list of composition relationships for an asset model of type <code>COMPONENT_MODEL</code>.
     * </p>
     * 
     * @param listCompositionRelationshipsRequest
     * @return Result of the ListCompositionRelationships operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListCompositionRelationships
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListCompositionRelationships"
     *      target="_top">AWS API Documentation</a>
     */
    ListCompositionRelationshipsResult listCompositionRelationships(ListCompositionRelationshipsRequest listCompositionRelationshipsRequest);

    /**
     * <p>
     * Retrieves a paginated list of dashboards for an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListDashboards
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    ListDashboardsResult listDashboards(ListDashboardsRequest listDashboardsRequest);

    /**
     * <p>
     * Retrieves a paginated list of gateways.
     * </p>
     * 
     * @param listGatewaysRequest
     * @return Result of the ListGateways operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListGateways
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListGateways" target="_top">AWS API
     *      Documentation</a>
     */
    ListGatewaysResult listGateways(ListGatewaysRequest listGatewaysRequest);

    /**
     * <p>
     * Retrieves a paginated list of IoT SiteWise Monitor portals.
     * </p>
     * 
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListPortals
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListPortals" target="_top">AWS API
     *      Documentation</a>
     */
    ListPortalsResult listPortals(ListPortalsRequest listPortalsRequest);

    /**
     * <p>
     * Retrieves a paginated list of assets associated with an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param listProjectAssetsRequest
     * @return Result of the ListProjectAssets operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListProjectAssets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjectAssets" target="_top">AWS
     *      API Documentation</a>
     */
    ListProjectAssetsResult listProjectAssets(ListProjectAssetsRequest listProjectAssetsRequest);

    /**
     * <p>
     * Retrieves a paginated list of projects for an IoT SiteWise Monitor portal.
     * </p>
     * 
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListProjects
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListProjects" target="_top">AWS API
     *      Documentation</a>
     */
    ListProjectsResult listProjects(ListProjectsRequest listProjectsRequest);

    /**
     * <p>
     * Retrieves the list of tags for an IoT SiteWise resource.
     * </p>
     * 
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @sample AWSIoTSiteWise.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest);

    /**
     * <p>
     * Retrieves a paginated list of time series (data streams).
     * </p>
     * 
     * @param listTimeSeriesRequest
     * @return Result of the ListTimeSeries operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.ListTimeSeries
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/ListTimeSeries" target="_top">AWS API
     *      Documentation</a>
     */
    ListTimeSeriesResult listTimeSeries(ListTimeSeriesRequest listTimeSeriesRequest);

    /**
     * <p>
     * Sets the default encryption configuration for the Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/key-management.html">Key management</a> in the
     * <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param putDefaultEncryptionConfigurationRequest
     * @return Result of the PutDefaultEncryptionConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.PutDefaultEncryptionConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutDefaultEncryptionConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    PutDefaultEncryptionConfigurationResult putDefaultEncryptionConfiguration(PutDefaultEncryptionConfigurationRequest putDefaultEncryptionConfigurationRequest);

    /**
     * <p>
     * Sets logging options for IoT SiteWise.
     * </p>
     * 
     * @param putLoggingOptionsRequest
     * @return Result of the PutLoggingOptions operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @sample AWSIoTSiteWise.PutLoggingOptions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutLoggingOptions" target="_top">AWS
     *      API Documentation</a>
     */
    PutLoggingOptionsResult putLoggingOptions(PutLoggingOptionsRequest putLoggingOptionsRequest);

    /**
     * <p>
     * Configures storage settings for IoT SiteWise.
     * </p>
     * 
     * @param putStorageConfigurationRequest
     * @return Result of the PutStorageConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.PutStorageConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/PutStorageConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    PutStorageConfigurationResult putStorageConfiguration(PutStorageConfigurationRequest putStorageConfigurationRequest);

    /**
     * <p>
     * Adds tags to an IoT SiteWise resource. If a tag already exists for the resource, this operation updates the tag's
     * value.
     * </p>
     * 
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @throws TooManyTagsException
     *         You've reached the limit for the number of tags allowed for a resource. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html#tag-conventions">Tag naming limits
     *         and requirements</a> in the <i>Amazon Web Services General Reference</i>.
     * @sample AWSIoTSiteWise.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    TagResourceResult tagResource(TagResourceRequest tagResourceRequest);

    /**
     * <p>
     * Removes a tag from an IoT SiteWise resource.
     * </p>
     * 
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws UnauthorizedException
     *         You are not authorized.
     * @sample AWSIoTSiteWise.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    UntagResourceResult untagResource(UntagResourceRequest untagResourceRequest);

    /**
     * <p>
     * Updates an existing access policy that specifies an identity's access to an IoT SiteWise Monitor portal or
     * project resource.
     * </p>
     * 
     * @param updateAccessPolicyRequest
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateAccessPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    UpdateAccessPolicyResult updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest);

    /**
     * <p>
     * Updates an asset's name. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @param updateAssetRequest
     * @return Result of the UpdateAsset operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.UpdateAsset
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAsset" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateAssetResult updateAsset(UpdateAssetRequest updateAssetRequest);

    /**
     * <p>
     * Updates an asset model and all of the assets that were created from the model. Each asset created from the model
     * inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from an asset model, IoT SiteWise deletes all previous data for that property. You can’t
     * change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing asset model property with a new one with the same <code>name</code>, do the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModel</code> request that includes the new property. The new asset property will
     * have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important>
     * 
     * @param updateAssetModelRequest
     * @return Result of the UpdateAssetModel operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.UpdateAssetModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModel" target="_top">AWS
     *      API Documentation</a>
     */
    UpdateAssetModelResult updateAssetModel(UpdateAssetModelRequest updateAssetModelRequest);

    /**
     * <p>
     * Updates a composite model and all of the assets that were created from the model. Each asset created from the
     * model inherits the updated asset model's property and hierarchy definitions. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/update-assets-and-models.html">Updating assets
     * and models</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <important>
     * <p>
     * If you remove a property from a composite asset model, IoT SiteWise deletes all previous data for that property.
     * You can’t change the type or data type of an existing property.
     * </p>
     * <p>
     * To replace an existing composite asset model property with a new one with the same <code>name</code>, do the
     * following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Submit an <code>UpdateAssetModelCompositeModel</code> request with the entire existing property removed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a second <code>UpdateAssetModelCompositeModel</code> request that includes the new property. The new asset
     * property will have the same <code>name</code> as the previous one and IoT SiteWise will generate a new unique
     * <code>id</code>.
     * </p>
     * </li>
     * </ol>
     * </important>
     * 
     * @param updateAssetModelCompositeModelRequest
     * @return Result of the UpdateAssetModelCompositeModel operation returned by the service.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateAssetModelCompositeModel
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetModelCompositeModel"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateAssetModelCompositeModelResult updateAssetModelCompositeModel(UpdateAssetModelCompositeModelRequest updateAssetModelCompositeModelRequest);

    /**
     * <p>
     * Updates an asset property's alias and notification state.
     * </p>
     * <important>
     * <p>
     * This operation overwrites the property's existing alias and notification state. To keep your existing property's
     * alias or notification state, you must include the existing values in the UpdateAssetProperty request. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeAssetProperty.html"
     * >DescribeAssetProperty</a>.
     * </p>
     * </important>
     * 
     * @param updateAssetPropertyRequest
     * @return Result of the UpdateAssetProperty operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.UpdateAssetProperty
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateAssetProperty"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateAssetPropertyResult updateAssetProperty(UpdateAssetPropertyRequest updateAssetPropertyRequest);

    /**
     * <p>
     * Updates an IoT SiteWise Monitor dashboard.
     * </p>
     * 
     * @param updateDashboardRequest
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateDashboard
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    UpdateDashboardResult updateDashboard(UpdateDashboardRequest updateDashboardRequest);

    /**
     * <p>
     * Updates a gateway's name.
     * </p>
     * 
     * @param updateGatewayRequest
     * @return Result of the UpdateGateway operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateGateway
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGateway" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateGatewayResult updateGateway(UpdateGatewayRequest updateGatewayRequest);

    /**
     * <p>
     * Updates a gateway capability configuration or defines a new capability configuration. Each gateway capability
     * defines data sources for a gateway. A capability configuration can contain multiple data source configurations.
     * If you define OPC-UA sources for a gateway in the IoT SiteWise console, all of your OPC-UA sources are stored in
     * one capability configuration. To list all capability configurations for a gateway, use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGateway.html">DescribeGateway</a>.
     * </p>
     * 
     * @param updateGatewayCapabilityConfigurationRequest
     * @return Result of the UpdateGatewayCapabilityConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws LimitExceededException
     *         You've reached the limit for a resource. For example, this can occur if you're trying to associate more
     *         than the allowed number of child assets or attempting to create more than the allowed number of
     *         properties for an asset model.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateGatewayCapabilityConfiguration
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateGatewayCapabilityConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    UpdateGatewayCapabilityConfigurationResult updateGatewayCapabilityConfiguration(
            UpdateGatewayCapabilityConfigurationRequest updateGatewayCapabilityConfigurationRequest);

    /**
     * <p>
     * Updates an IoT SiteWise Monitor portal.
     * </p>
     * 
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @throws ConflictingOperationException
     *         Your request has conflicting operations. This can occur if you're trying to perform more than one
     *         operation on the same resource at the same time.
     * @sample AWSIoTSiteWise.UpdatePortal
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdatePortal" target="_top">AWS API
     *      Documentation</a>
     */
    UpdatePortalResult updatePortal(UpdatePortalRequest updatePortalRequest);

    /**
     * <p>
     * Updates an IoT SiteWise Monitor project.
     * </p>
     * 
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InvalidRequestException
     *         The request isn't valid. This can occur if your request contains malformed JSON or unsupported
     *         characters. Check your request and try again.
     * @throws ResourceNotFoundException
     *         The requested resource can't be found.
     * @throws InternalFailureException
     *         IoT SiteWise can't process your request right now. Try again later.
     * @throws ThrottlingException
     *         Your request exceeded a rate limit. For example, you might have exceeded the number of IoT SiteWise
     *         assets that can be created per second, the allowed number of messages per second, and so on.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     * @sample AWSIoTSiteWise.UpdateProject
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotsitewise-2019-12-02/UpdateProject" target="_top">AWS API
     *      Documentation</a>
     */
    UpdateProjectResult updateProject(UpdateProjectRequest updateProjectRequest);

    /**
     * Shuts down this client object, releasing any resources that might be held open. This is an optional method, and
     * callers are not expected to call it, but can if they want to explicitly release any open resources. Once a client
     * has been shutdown, it should not be used to make any more requests.
     */
    void shutdown();

    /**
     * Returns additional metadata for a previously executed successful request, typically used for debugging issues
     * where a service isn't acting as expected. This data isn't considered part of the result data returned by an
     * operation, so it's available through this separate, diagnostic interface.
     * <p>
     * Response metadata is only cached for a limited period of time, so if you need to access this extra diagnostic
     * information for an executed request, you should use this method to retrieve it as soon as possible after
     * executing a request.
     *
     * @param request
     *        The originally executed request.
     *
     * @return The response metadata for the specified request, or null if none is available.
     */
    ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request);

    AWSIoTSiteWiseWaiters waiters();

}
