/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotevents.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains the configuration information of SMS notifications.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotevents-2018-07-27/SMSConfiguration" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SMSConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The sender ID.
     * </p>
     */
    private String senderId;
    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     */
    private String additionalMessage;
    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     */
    private java.util.List<RecipientDetail> recipients;

    /**
     * <p>
     * The sender ID.
     * </p>
     * 
     * @param senderId
     *        The sender ID.
     */

    public void setSenderId(String senderId) {
        this.senderId = senderId;
    }

    /**
     * <p>
     * The sender ID.
     * </p>
     * 
     * @return The sender ID.
     */

    public String getSenderId() {
        return this.senderId;
    }

    /**
     * <p>
     * The sender ID.
     * </p>
     * 
     * @param senderId
     *        The sender ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SMSConfiguration withSenderId(String senderId) {
        setSenderId(senderId);
        return this;
    }

    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     * 
     * @param additionalMessage
     *        The message that you want to send. The message can be up to 200 characters.
     */

    public void setAdditionalMessage(String additionalMessage) {
        this.additionalMessage = additionalMessage;
    }

    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     * 
     * @return The message that you want to send. The message can be up to 200 characters.
     */

    public String getAdditionalMessage() {
        return this.additionalMessage;
    }

    /**
     * <p>
     * The message that you want to send. The message can be up to 200 characters.
     * </p>
     * 
     * @param additionalMessage
     *        The message that you want to send. The message can be up to 200 characters.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SMSConfiguration withAdditionalMessage(String additionalMessage) {
        setAdditionalMessage(additionalMessage);
        return this;
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     * 
     * @return Specifies one or more recipients who receive the message.</p> <important>
     *         <p>
     *         You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *         that receive SMS messages to your AWS SSO store</a>.
     *         </p>
     */

    public java.util.List<RecipientDetail> getRecipients() {
        return recipients;
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     * 
     * @param recipients
     *        Specifies one or more recipients who receive the message.</p> <important>
     *        <p>
     *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *        that receive SMS messages to your AWS SSO store</a>.
     *        </p>
     */

    public void setRecipients(java.util.Collection<RecipientDetail> recipients) {
        if (recipients == null) {
            this.recipients = null;
            return;
        }

        this.recipients = new java.util.ArrayList<RecipientDetail>(recipients);
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setRecipients(java.util.Collection)} or {@link #withRecipients(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param recipients
     *        Specifies one or more recipients who receive the message.</p> <important>
     *        <p>
     *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *        that receive SMS messages to your AWS SSO store</a>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SMSConfiguration withRecipients(RecipientDetail... recipients) {
        if (this.recipients == null) {
            setRecipients(new java.util.ArrayList<RecipientDetail>(recipients.length));
        }
        for (RecipientDetail ele : recipients) {
            this.recipients.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Specifies one or more recipients who receive the message.
     * </p>
     * <important>
     * <p>
     * You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users that
     * receive SMS messages to your AWS SSO store</a>.
     * </p>
     * </important>
     * 
     * @param recipients
     *        Specifies one or more recipients who receive the message.</p> <important>
     *        <p>
     *        You must <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html">add the users
     *        that receive SMS messages to your AWS SSO store</a>.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SMSConfiguration withRecipients(java.util.Collection<RecipientDetail> recipients) {
        setRecipients(recipients);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSenderId() != null)
            sb.append("SenderId: ").append(getSenderId()).append(",");
        if (getAdditionalMessage() != null)
            sb.append("AdditionalMessage: ").append(getAdditionalMessage()).append(",");
        if (getRecipients() != null)
            sb.append("Recipients: ").append(getRecipients());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SMSConfiguration == false)
            return false;
        SMSConfiguration other = (SMSConfiguration) obj;
        if (other.getSenderId() == null ^ this.getSenderId() == null)
            return false;
        if (other.getSenderId() != null && other.getSenderId().equals(this.getSenderId()) == false)
            return false;
        if (other.getAdditionalMessage() == null ^ this.getAdditionalMessage() == null)
            return false;
        if (other.getAdditionalMessage() != null && other.getAdditionalMessage().equals(this.getAdditionalMessage()) == false)
            return false;
        if (other.getRecipients() == null ^ this.getRecipients() == null)
            return false;
        if (other.getRecipients() != null && other.getRecipients().equals(this.getRecipients()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSenderId() == null) ? 0 : getSenderId().hashCode());
        hashCode = prime * hashCode + ((getAdditionalMessage() == null) ? 0 : getAdditionalMessage().hashCode());
        hashCode = prime * hashCode + ((getRecipients() == null) ? 0 : getRecipients().hashCode());
        return hashCode;
    }

    @Override
    public SMSConfiguration clone() {
        try {
            return (SMSConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.iotevents.model.transform.SMSConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
