/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.deadline.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.deadline.model.*;

import com.amazonaws.util.IdempotentUtils;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * UpdateBudgetRequestMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class UpdateBudgetRequestMarshaller {

    private static final MarshallingInfo<List> ACTIONSTOADD_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("actionsToAdd").build();
    private static final MarshallingInfo<List> ACTIONSTOREMOVE_BINDING = MarshallingInfo.builder(MarshallingType.LIST)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actionsToRemove").build();
    private static final MarshallingInfo<Float> APPROXIMATEDOLLARLIMIT_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("approximateDollarLimit").build();
    private static final MarshallingInfo<String> BUDGETID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("budgetId").build();
    private static final MarshallingInfo<String> CLIENTTOKEN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Client-Token")
            .defaultValueSupplier(com.amazonaws.util.IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<String> DISPLAYNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("displayName").build();
    private static final MarshallingInfo<String> FARMID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PATH)
            .marshallLocationName("farmId").build();
    private static final MarshallingInfo<StructuredPojo> SCHEDULE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schedule").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("status").build();

    private static final UpdateBudgetRequestMarshaller instance = new UpdateBudgetRequestMarshaller();

    public static UpdateBudgetRequestMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(UpdateBudgetRequest updateBudgetRequest, ProtocolMarshaller protocolMarshaller) {

        if (updateBudgetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(updateBudgetRequest.getActionsToAdd(), ACTIONSTOADD_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getActionsToRemove(), ACTIONSTOREMOVE_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getApproximateDollarLimit(), APPROXIMATEDOLLARLIMIT_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getBudgetId(), BUDGETID_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getClientToken(), CLIENTTOKEN_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getDisplayName(), DISPLAYNAME_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getFarmId(), FARMID_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getSchedule(), SCHEDULE_BINDING);
            protocolMarshaller.marshall(updateBudgetRequest.getStatus(), STATUS_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
