/*
 * Decompiled with CFR 0.152.
 */
package dev.minn.jda.ktx.messages;

import dev.minn.jda.ktx.messages.MentionConfig;
import java.util.Collection;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\u0011\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0003H\u0086\u0002J\t\u0010$\u001a\u00020%H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012\u00a8\u0006'"}, d2={"Ldev/minn/jda/ktx/messages/Mentions;", "", "users", "Ldev/minn/jda/ktx/messages/MentionConfig;", "roles", "everyone", "", "here", "(Ldev/minn/jda/ktx/messages/MentionConfig;Ldev/minn/jda/ktx/messages/MentionConfig;ZZ)V", "getEveryone", "()Z", "setEveryone", "(Z)V", "getHere", "setHere", "getRoles", "()Ldev/minn/jda/ktx/messages/MentionConfig;", "setRoles", "(Ldev/minn/jda/ktx/messages/MentionConfig;)V", "getUsers", "setUsers", "apply", "", "request", "Lnet/dv8tion/jda/api/utils/messages/MessageRequest;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "plusAssign", "config", "toString", "", "Companion", "jda-ktx"})
public final class Mentions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MentionConfig users;
    @NotNull
    private MentionConfig roles;
    private boolean everyone;
    private boolean here;

    public Mentions(@NotNull MentionConfig users, @NotNull MentionConfig roles, boolean everyone, boolean here) {
        Intrinsics.checkNotNullParameter((Object)users, (String)"users");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        this.users = users;
        this.roles = roles;
        this.everyone = everyone;
        this.here = here;
    }

    @NotNull
    public final MentionConfig getUsers() {
        return this.users;
    }

    public final void setUsers(@NotNull MentionConfig mentionConfig) {
        Intrinsics.checkNotNullParameter((Object)mentionConfig, (String)"<set-?>");
        this.users = mentionConfig;
    }

    @NotNull
    public final MentionConfig getRoles() {
        return this.roles;
    }

    public final void setRoles(@NotNull MentionConfig mentionConfig) {
        Intrinsics.checkNotNullParameter((Object)mentionConfig, (String)"<set-?>");
        this.roles = mentionConfig;
    }

    public final boolean getEveryone() {
        return this.everyone;
    }

    public final void setEveryone(boolean bl) {
        this.everyone = bl;
    }

    public final boolean getHere() {
        return this.here;
    }

    public final void setHere(boolean bl) {
        this.here = bl;
    }

    public final void apply(@NotNull MessageRequest<?> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        EnumSet<Message.MentionType> types = EnumSet.noneOf(Message.MentionType.class);
        if (this.everyone) {
            types.add(Message.MentionType.EVERYONE);
        }
        if (this.here) {
            types.add(Message.MentionType.HERE);
        }
        if (this.users.getAny()) {
            types.add(Message.MentionType.USER);
        }
        if (this.roles.getAny()) {
            types.add(Message.MentionType.ROLE);
        }
        request.setAllowedMentions((Collection)types);
        if (!this.users.getAny()) {
            this.users.getList().forEach(arg_0 -> Mentions.apply$lambda$0((Function1)new Function1<Long, Unit>(request){

                public final void invoke(long p0) {
                    long[] lArray = new long[]{p0};
                    ((MessageRequest)this.receiver).mentionUsers(lArray);
                }
            }, arg_0));
        }
        if (!this.roles.getAny()) {
            this.roles.getList().forEach(arg_0 -> Mentions.apply$lambda$1((Function1)new Function1<Long, Unit>(request){

                public final void invoke(long p0) {
                    long[] lArray = new long[]{p0};
                    ((MessageRequest)this.receiver).mentionRoles(lArray);
                }
            }, arg_0));
        }
    }

    public final void plusAssign(@NotNull MentionConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        switch (WhenMappings.$EnumSwitchMapping$0[config.getType().ordinal()]) {
            case 1: {
                this.everyone = config.getAny();
                break;
            }
            case 2: {
                this.here = config.getAny();
                break;
            }
            case 3: {
                this.users = config;
                break;
            }
            case 4: {
                this.roles = config;
            }
        }
    }

    @NotNull
    public final MentionConfig component1() {
        return this.users;
    }

    @NotNull
    public final MentionConfig component2() {
        return this.roles;
    }

    public final boolean component3() {
        return this.everyone;
    }

    public final boolean component4() {
        return this.here;
    }

    @NotNull
    public final Mentions copy(@NotNull MentionConfig users, @NotNull MentionConfig roles, boolean everyone, boolean here) {
        Intrinsics.checkNotNullParameter((Object)users, (String)"users");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        return new Mentions(users, roles, everyone, here);
    }

    public static /* synthetic */ Mentions copy$default(Mentions mentions, MentionConfig mentionConfig, MentionConfig mentionConfig2, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            mentionConfig = mentions.users;
        }
        if ((n & 2) != 0) {
            mentionConfig2 = mentions.roles;
        }
        if ((n & 4) != 0) {
            bl = mentions.everyone;
        }
        if ((n & 8) != 0) {
            bl2 = mentions.here;
        }
        return mentions.copy(mentionConfig, mentionConfig2, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "Mentions(users=" + this.users + ", roles=" + this.roles + ", everyone=" + this.everyone + ", here=" + this.here + ')';
    }

    public int hashCode() {
        int result2 = this.users.hashCode();
        result2 = result2 * 31 + this.roles.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.everyone);
        result2 = result2 * 31 + Boolean.hashCode(this.here);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mentions)) {
            return false;
        }
        Mentions mentions = (Mentions)other;
        if (!Intrinsics.areEqual((Object)this.users, (Object)mentions.users)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.roles, (Object)mentions.roles)) {
            return false;
        }
        if (this.everyone != mentions.everyone) {
            return false;
        }
        return this.here == mentions.here;
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u001f\u0010\u0005\u001a\u00020\u00042\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Ldev/minn/jda/ktx/messages/Mentions$Companion;", "", "()V", "default", "Ldev/minn/jda/ktx/messages/Mentions;", "of", "configs", "", "Ldev/minn/jda/ktx/messages/MentionConfig;", "([Ldev/minn/jda/ktx/messages/MentionConfig;)Ldev/minn/jda/ktx/messages/Mentions;", "jda-ktx"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Mentions default() {
            EnumSet enumSet = MessageRequest.getDefaultMentions();
            Intrinsics.checkNotNullExpressionValue((Object)enumSet, (String)"getDefaultMentions(...)");
            EnumSet defaultTypes = enumSet;
            return new Mentions(new MentionConfig(defaultTypes.contains(Message.MentionType.USER), CollectionsKt.emptyList(), Message.MentionType.USER), new MentionConfig(defaultTypes.contains(Message.MentionType.ROLE), CollectionsKt.emptyList(), Message.MentionType.ROLE), defaultTypes.contains(Message.MentionType.EVERYONE), defaultTypes.contains(Message.MentionType.HERE));
        }

        @NotNull
        public final Mentions of(MentionConfig ... configs) {
            Intrinsics.checkNotNullParameter((Object)configs, (String)"configs");
            Mentions allowedMentions = this.default();
            for (MentionConfig config : configs) {
                allowedMentions.plusAssign(config);
            }
            return allowedMentions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.MentionType.values().length];
            try {
                nArray[Message.MentionType.EVERYONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.MentionType.HERE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.MentionType.USER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Message.MentionType.ROLE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

