/*
 * Decompiled with CFR 0.152.
 */
package dev.minn.jda.ktx.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.filter.Filter;
import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import club.minnced.discord.webhook.receive.ReadonlyMessage;
import java.nio.charset.Charset;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0016J\b\u0010\"\u001a\u00020\u001eH\u0016R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0012\"\u0004\b\u0019\u0010\u0014R\u001a\u0010\u001a\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0014\u00a8\u0006$"}, d2={"Ldev/minn/jda/ktx/logback/WebhookAppender;", "Lch/qos/logback/core/AppenderBase;", "Lch/qos/logback/classic/spi/ILoggingEvent;", "()V", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "client", "Lclub/minnced/discord/webhook/WebhookClient;", "encoder", "Lch/qos/logback/classic/encoder/PatternLayoutEncoder;", "getEncoder", "()Lch/qos/logback/classic/encoder/PatternLayoutEncoder;", "setEncoder", "(Lch/qos/logback/classic/encoder/PatternLayoutEncoder;)V", "level", "", "getLevel", "()Ljava/lang/String;", "setLevel", "(Ljava/lang/String;)V", "pool", "Ljava/util/concurrent/ScheduledExecutorService;", "timeout", "getTimeout", "setTimeout", "url", "getUrl", "setUrl", "append", "", "event", "flush", "start", "stop", "Companion", "jda-ktx"})
@SourceDebugExtension(value={"SMAP\nWebhookAppender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebhookAppender.kt\ndev/minn/jda/ktx/logback/WebhookAppender\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n1313#2,2:100\n*S KotlinDebug\n*F\n+ 1 WebhookAppender.kt\ndev/minn/jda/ktx/logback/WebhookAppender\n*L\n56#1:100,2\n*E\n"})
public class WebhookAppender
extends AppenderBase<ILoggingEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String timeout = "30000";
    @NotNull
    private String level = "warn";
    public PatternLayoutEncoder encoder;
    public String url;
    private WebhookClient client;
    private ScheduledExecutorService pool;
    @NotNull
    private final StringBuilder buffer = new StringBuilder(2000);
    private static final ThreadLocal<Boolean> guard = ThreadLocal.withInitial(WebhookAppender::guard$lambda$8);

    @NotNull
    public final String getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.timeout = string;
    }

    @NotNull
    public final String getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.level = string;
    }

    @NotNull
    public final PatternLayoutEncoder getEncoder() {
        PatternLayoutEncoder patternLayoutEncoder = this.encoder;
        if (patternLayoutEncoder != null) {
            return patternLayoutEncoder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"encoder");
        return null;
    }

    public final void setEncoder(@NotNull PatternLayoutEncoder patternLayoutEncoder) {
        Intrinsics.checkNotNullParameter((Object)patternLayoutEncoder, (String)"<set-?>");
        this.encoder = patternLayoutEncoder;
    }

    @NotNull
    public final String getUrl() {
        String string = this.url;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
        return null;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void flush() {
        StringBuilder stringBuilder = this.buffer;
        synchronized (stringBuilder) {
            boolean bl = false;
            if (!(((CharSequence)this.buffer).length() == 0)) {
                String message = "```ansi\n" + this.buffer + "```";
                this.buffer.setLength(0);
                WebhookClient webhookClient = this.client;
                if (webhookClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    webhookClient = null;
                }
                webhookClient.send(message).exceptionally(WebhookAppender::flush$lambda$1$lambda$0);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(@NotNull ILoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Boolean bl = guard.get();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        if (bl.booleanValue()) {
            return;
        }
        byte[] byArray = this.getEncoder().encode((Object)event);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(...)");
        byte[] byArray2 = byArray;
        Comparable<Charset> comparable = Charsets.UTF_8;
        String msg = new String(byArray2, (Charset)comparable);
        comparable = this.buffer;
        synchronized (comparable) {
            boolean bl2 = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)StringsKt.lineSequence((CharSequence)msg), WebhookAppender::append$lambda$4$lambda$2);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String line = (String)element$iv;
                boolean bl3 = false;
                if (this.buffer.length() + line.length() > 1900) {
                    this.flush();
                }
                this.buffer.append(line).append("\n");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void start() {
        void $this$start_u24lambda_u245;
        ThresholdFilter thresholdFilter;
        if (this.encoder == null) {
            throw new AssertionError((Object)"Missing pattern encoder for webhook appender");
        }
        if (this.url == null) {
            throw new AssertionError((Object)"Missing url for webhook appender");
        }
        ThresholdFilter thresholdFilter2 = thresholdFilter = new ThresholdFilter();
        WebhookAppender webhookAppender = this;
        boolean bl = false;
        $this$start_u24lambda_u245.setLevel(this.level);
        $this$start_u24lambda_u245.start();
        webhookAppender.addFilter((Filter)thresholdFilter);
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(WebhookAppender::start$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"newSingleThreadScheduledExecutor(...)");
        this.pool = scheduledExecutorService;
        WebhookClientBuilder webhookClientBuilder = new WebhookClientBuilder(this.getUrl()).setWait(false);
        ScheduledExecutorService scheduledExecutorService2 = this.pool;
        if (scheduledExecutorService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
            scheduledExecutorService2 = null;
        }
        WebhookClient webhookClient = webhookClientBuilder.setExecutorService(scheduledExecutorService2).build().setTimeout(Long.parseLong(this.timeout));
        Intrinsics.checkNotNullExpressionValue((Object)webhookClient, (String)"setTimeout(...)");
        this.client = webhookClient;
        ScheduledExecutorService scheduledExecutorService3 = this.pool;
        if (scheduledExecutorService3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
            scheduledExecutorService3 = null;
        }
        scheduledExecutorService3.scheduleAtFixedRate(this::flush, 500L, 500L, TimeUnit.MILLISECONDS);
        this.getEncoder().start();
        super.start();
    }

    public void stop() {
        if (this.pool != null) {
            ScheduledExecutorService scheduledExecutorService = this.pool;
            if (scheduledExecutorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pool");
                scheduledExecutorService = null;
            }
            scheduledExecutorService.shutdown();
        }
        super.stop();
    }

    private static final ReadonlyMessage flush$lambda$1$lambda$0(Throwable it) {
        return null;
    }

    private static final boolean append$lambda$4$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !StringsKt.isBlank((CharSequence)it);
    }

    private static final Unit start$lambda$7$lambda$6(Runnable $it) {
        guard.set(true);
        $it.run();
        return Unit.INSTANCE;
    }

    private static final Thread start$lambda$7(Runnable it) {
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"WebhookAppender", (int)0, () -> WebhookAppender.start$lambda$7$lambda$6(it), (int)20, null);
    }

    private static final Boolean guard$lambda$8() {
        return false;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ldev/minn/jda/ktx/logback/WebhookAppender$Companion;", "", "()V", "guard", "Ljava/lang/ThreadLocal;", "", "kotlin.jvm.PlatformType", "jda-ktx"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

