/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core.entities;

import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.EntityRelationship;
import au.com.mountainpass.hyperstate.core.EntityRepository;
import au.com.mountainpass.hyperstate.core.JavaAction;
import au.com.mountainpass.hyperstate.core.JavaLink;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.NavigationalRelationship;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.core.entities.LinkedEntity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.Identifiable;
import org.springframework.http.HttpMethod;

@JsonPropertyOrder(value={"class", "properties", "entities", "actions", "links", "title"})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class EntityWrapper<T>
extends Entity
implements Identifiable<String> {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final int PAGE_SIZE = 10;
    private Map<String, Action<?>> actions = new HashMap();
    private Collection<EntityRelationship> entities = null;
    @JsonProperty(value="links")
    private Set<NavigationalRelationship> navigationalRelationships = new HashSet<NavigationalRelationship>();
    T properties;
    private String path;
    private EntityRepository repository;

    protected EntityWrapper(@JsonProperty(value="properties") T properties) {
        this.properties = properties;
    }

    protected EntityWrapper(String path, T properties, String label, String ... natures) {
        super(label, natures);
        Method[] methods;
        this.properties = properties;
        this.path = path;
        this.add(new NavigationalRelationship(new JavaLink(this), "self"));
        block6: for (Method method : methods = this.getClass().getMethods()) {
            HttpMethod httpMethod = JavaAction.determineMethodNature(method);
            if (httpMethod == null) continue;
            switch (httpMethod) {
                case DELETE: {
                    this.actions.put(method.getName(), new JavaAction(this, method));
                    continue block6;
                }
                case POST: {
                    this.actions.put(method.getName(), new JavaAction(this, method));
                    continue block6;
                }
                case PUT: {
                    this.actions.put(method.getName(), new JavaAction(this, method));
                }
                case GET: {
                    this.actions.put(method.getName(), new JavaAction(this, method));
                }
            }
        }
    }

    public EntityWrapper(EntityWrapper<T> src) {
        super(src);
        this.properties = src.properties;
        this.path = src.path;
        this.actions = src.actions;
        this.entities = src.entities;
        this.navigationalRelationships = src.navigationalRelationships;
    }

    public void add(NavigationalRelationship navigationalRelationship) {
        this.navigationalRelationships.add(navigationalRelationship);
    }

    public Action<?> getAction(String identifier) {
        return this.actions.get(identifier);
    }

    @JsonProperty(value="actions")
    public ImmutableSet<Action<?>> getActions() {
        return ImmutableSet.copyOf(this.actions.values());
    }

    public CompletableFuture<Collection<EntityRelationship>> getEntities() {
        return this.getEntities(0);
    }

    @JsonProperty(value="entities")
    private Collection<EntityRelationship> getEntitiesAndJoin() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, URISyntaxException {
        return this.getEntities().join();
    }

    public void setRepository(EntityRepository repository) {
        this.repository = repository;
    }

    public CompletableFuture<Collection<EntityRelationship>> getEntities(int page) {
        if (this.entities != null) {
            return CompletableFuture.supplyAsync(() -> this.entities);
        }
        if (this.repository != null) {
            return this.repository.findChildren(this).thenApplyAsync(results -> results.skip(page * 10).limit(10L).collect(Collectors.toList()));
        }
        ArrayList rval = new ArrayList();
        return CompletableFuture.supplyAsync(() -> rval);
    }

    public Link getLink(String rel) {
        Optional<NavigationalRelationship> link = this.getLinks().stream().filter(l -> l.hasNature(rel)).findAny();
        if (link.isPresent()) {
            return link.get().getLink();
        }
        return null;
    }

    public ImmutableSet<NavigationalRelationship> getLinks() {
        return ImmutableSet.copyOf(this.navigationalRelationships);
    }

    public T getProperties() {
        return this.properties;
    }

    public <K, L extends EntityWrapper<K>> L reload(Class<L> type) {
        return (L)this;
    }

    public <K, L extends EntityWrapper<K>> L resolve(Class<L> type) {
        return (L)this;
    }

    public <K, L extends EntityWrapper<K>> L resolve(ParameterizedTypeReference<L> type) {
        return (L)this;
    }

    public void setActions(Action<?>[] actions) {
        for (Action<?> action : actions) {
            this.actions.put(action.getIdentifier(), action);
        }
    }

    public void setEntities(Collection<EntityRelationship> entityRelationships) {
        this.entities = entityRelationships;
    }

    @Override
    public LinkedEntity toLinkedEntity() {
        LinkedEntity linkedEntity = new LinkedEntity(this.getLink("self"), this.getLabel(), this.getNatures());
        return linkedEntity;
    }

    @Override
    @JsonIgnore
    public URI getAddress() {
        return this.getLink("self").getAddress();
    }

    @JsonIgnore
    public String getId() {
        return this.path;
    }
}

