/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.core;

import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.MediaTypes;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.hateoas.mvc.BasicLinkBuilder;
import org.springframework.http.MediaType;

public class JavaLink
extends Link {
    private EntityWrapper<?> entity;

    protected JavaLink() {
    }

    public JavaLink(EntityWrapper<?> entity) {
        this.entity = entity;
    }

    @Override
    public <T> T resolve(Class<T> type) {
        return (T)this.entity;
    }

    @Override
    public MediaType getRepresentationFormat() {
        return MediaTypes.SIREN_JSON;
    }

    @Override
    @JsonProperty(value="href")
    public URI getAddress() {
        return ((BasicLinkBuilder)BasicLinkBuilder.linkToCurrentMapping().slash(this.entity)).toUri();
    }

    @Override
    public <T> T resolve(ParameterizedTypeReference<T> type) {
        return (T)this.entity;
    }

    @Override
    public String getPath() {
        return this.entity.getId();
    }
}

