/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client.webdriver;

import au.com.mountainpass.hyperstate.client.CreateAction;
import au.com.mountainpass.hyperstate.client.DeleteAction;
import au.com.mountainpass.hyperstate.client.GetAction;
import au.com.mountainpass.hyperstate.client.UpdateAction;
import au.com.mountainpass.hyperstate.client.webdriver.WebDriverAddress;
import au.com.mountainpass.hyperstate.client.webdriver.WebDriverResolver;
import au.com.mountainpass.hyperstate.core.Action;
import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.EntityRelationship;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.NavigationalRelationship;
import au.com.mountainpass.hyperstate.core.Parameter;
import au.com.mountainpass.hyperstate.core.entities.Entity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.core.entities.LinkedEntity;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

class WebDriverEntityInterceptor<E>
implements MethodInterceptor {
    private final WebDriverResolver resolver;

    WebDriverEntityInterceptor(WebDriverResolver resolver) {
        this.resolver = resolver;
    }

    private Action<?> getAction(WebDriverResolver resolver, WebElement form) {
        List inputs = form.findElements(By.tagName((String)"input"));
        Parameter[] fields = new Parameter[inputs.size()];
        for (int i = 0; i < inputs.size(); ++i) {
            String type = ((WebElement)inputs.get(i)).getAttribute("type");
            String value = ((WebElement)inputs.get(i)).getAttribute("value");
            String name = ((WebElement)inputs.get(i)).getAttribute("name");
            fields[i] = new Parameter(name, type, value);
        }
        if (!form.findElements(By.xpath((String)".[@method='GET']")).isEmpty()) {
            return new GetAction(form.getAttribute("name"), (Address)new WebDriverAddress(resolver, form), fields);
        }
        if (!form.findElements(By.xpath((String)".[@method='POST']")).isEmpty()) {
            return new CreateAction(form.getAttribute("name"), (Address)new WebDriverAddress(resolver, form), fields);
        }
        if (!form.findElements(By.xpath((String)".[@method='PUT']")).isEmpty()) {
            return new UpdateAction(form.getAttribute("name"), (Address)new WebDriverAddress(resolver, form), fields);
        }
        if (!form.findElements(By.xpath((String)".[@method='DELETE']")).isEmpty()) {
            return new DeleteAction(form.getAttribute("name"), (Address)new WebDriverAddress(resolver, form), fields);
        }
        throw new NotImplementedException("unimplemented method for from: " + form.getAttribute("name"));
    }

    private Object getActions(WebDriverResolver resolver) {
        this.waitTillLoaded(5L);
        Set acctions = resolver.getWebDriver().findElement(By.id((String)"actions")).findElements(By.tagName((String)"form")).stream().map(we -> this.getAction(resolver, (WebElement)we)).collect(Collectors.toSet());
        return ImmutableSet.copyOf(acctions);
    }

    private Link getLink(WebDriverResolver resolver, WebElement a) {
        return new Link((Address)new WebDriverAddress(resolver, a), a.getText(), a.getAttribute("class").split("\\s"));
    }

    private ImmutableSet<NavigationalRelationship> getLinks(WebDriverResolver resolver) {
        this.waitTillLoaded(5L);
        return ImmutableSet.copyOf((Collection)resolver.getWebDriver().findElement(By.id((String)"links")).findElements(By.tagName((String)"a")).stream().map(we -> this.getNavigationalRelationship(resolver, (WebElement)we)).collect(Collectors.toSet()));
    }

    private ImmutableSet<String> getClasses() {
        this.waitTillLoaded(5L);
        HashSet<String> rval = new HashSet<String>(Arrays.asList(this.resolver.getWebDriver().findElement(By.tagName((String)"html")).getAttribute("class").split("\\s+")));
        return ImmutableSet.copyOf((Collection)rval.stream().filter(entry -> !entry.startsWith("status")).collect(Collectors.toSet()));
    }

    private NavigationalRelationship getNavigationalRelationship(WebDriverResolver resolver, WebElement a) {
        return new NavigationalRelationship(this.getLink(resolver, a), a.getAttribute("rel").split("\\s+"));
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (method.getName().equals("getAction")) {
            this.waitTillLoaded(5L);
            String actionName = args[0].toString();
            return this.getAction(this.resolver, this.resolver.getWebDriver().findElement(By.name((String)actionName)));
        }
        if (method.getName().equals("reload")) {
            this.resolver.getWebDriver().get(this.resolver.getWebDriver().getCurrentUrl());
            return this.resolver.createProxy((Class)args[0]);
        }
        if (method.getName().equals("resolve")) {
            return CompletableFuture.supplyAsync(() -> this.resolver.createProxy((Class)args[0]));
        }
        if (method.getName().equals("getEntities")) {
            List entities = this.resolver.getWebDriver().findElements(By.cssSelector((String)"#entities > div.row > a"));
            ArrayList<EntityRelationship> rval = new ArrayList<EntityRelationship>();
            for (WebElement entity : entities) {
                HashSet<String> classes = new HashSet<String>(Arrays.asList(entity.getAttribute("class").split("\\s")));
                String title = entity.getText();
                String[] rels = new String[]{};
                WebDriverAddress webDriverAddress = new WebDriverAddress(this.resolver, entity);
                Link link = new Link((Address)webDriverAddress, title, new String[0]);
                LinkedEntity linkedEntity = new LinkedEntity(link, title, classes);
                rval.add(new EntityRelationship((Entity)linkedEntity, rels));
            }
            return rval;
        }
        if (method.getName().equals("getProperties")) {
            Object instance = methodProxy.invokeSuper(obj, new Object[0]);
            Enhancer propertiesEnhancer = new Enhancer();
            propertiesEnhancer.setClassLoader(instance.getClass().getClassLoader());
            propertiesEnhancer.setSuperclass(instance.getClass());
            propertiesEnhancer.setCallback((Callback)new MethodInterceptor(){

                public Object intercept(Object properties, Method propertiesMethod, Object[] propertiesMethodArgs, MethodProxy propertiesMethodProxy) throws Throwable {
                    String key = propertiesMethod.getName();
                    if ("get".equals(key)) {
                        key = propertiesMethodArgs[0].toString();
                    } else {
                        key = key.replaceFirst("^get", "").replaceFirst("^is", "");
                        key = key.substring(0, 1).toLowerCase() + key.substring(1);
                    }
                    key = "property:" + key;
                    String value = WebDriverEntityInterceptor.this.resolver.getWebDriver().findElement(By.id((String)key)).getText();
                    if (propertiesMethod.getReturnType().isAssignableFrom(String.class)) {
                        return value;
                    }
                    if (propertiesMethod.getReturnType().isAssignableFrom(Boolean.TYPE)) {
                        return Boolean.parseBoolean(value);
                    }
                    if (propertiesMethod.getReturnType().isAssignableFrom(LocalDateTime.class)) {
                        return LocalDateTime.parse(value);
                    }
                    throw new NotImplementedException("conversion not implemented for " + propertiesMethod.getReturnType());
                }
            });
            return propertiesEnhancer.create(new Class[0], new Object[0]);
        }
        if (method.getName().equals("getClasses")) {
            return this.getClasses();
        }
        if (method.getName().equals("getActions")) {
            return this.getActions(this.resolver);
        }
        if (method.getName().equals("getLinks")) {
            return this.getLinks(this.resolver);
        }
        if (method.getName().equals("getLink")) {
            Optional<NavigationalRelationship> link = this.getLinks(this.resolver).stream().filter(l -> l.hasRelationship((String)args[0])).findAny();
            if (link.isPresent()) {
                return link.get().getLink();
            }
            return null;
        }
        if (method.getName().equals("toLinkedEntity") || method.getName().equals("getProperties") || method.getName().equals("getTitle") || method.getName().equals("getLink")) {
            throw new NotImplementedException("method: " + method.getName());
        }
        if (method.getName().equals("toString") || method.getName().equals("hashCode")) {
            return methodProxy.invokeSuper(obj, new Object[0]);
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        java.lang.reflect.Parameter[] params = method.getParameters();
        for (int i = 0; i < params.length; ++i) {
            context.put(params[i].getName(), args[i]);
        }
        Action action = ((EntityWrapper)obj).getAction(method.getName());
        if (action == null) {
            throw new RuntimeException("The method `" + method.getName() + "` cannot be executed remotely");
        }
        CompletableFuture result = action.invoke(context);
        return result;
    }

    private void waitTillLoaded(long timeoutInSeconds) {
        new WebDriverWait(this.resolver.getWebDriver(), timeoutInSeconds).until((Function)ExpectedConditions.invisibilityOfElementLocated((By)By.id((String)"loading")));
        new WebDriverWait(this.resolver.getWebDriver(), timeoutInSeconds).until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.id((String)"loaded")));
        new WebDriverWait(this.resolver.getWebDriver(), timeoutInSeconds).until(WebDriverResolver.angularHasFinishedProcessing());
    }
}

