/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client.webdriver;

import au.com.mountainpass.hyperstate.client.webdriver.WebDriverAddress;
import au.com.mountainpass.hyperstate.client.webdriver.WebDriverEntityInterceptor;
import au.com.mountainpass.hyperstate.core.Address;
import au.com.mountainpass.hyperstate.core.Link;
import au.com.mountainpass.hyperstate.core.Resolver;
import au.com.mountainpass.hyperstate.core.entities.CreatedEntity;
import au.com.mountainpass.hyperstate.core.entities.DeletedEntity;
import au.com.mountainpass.hyperstate.core.entities.EntityWrapper;
import au.com.mountainpass.hyperstate.core.entities.UpdatedEntity;
import au.com.mountainpass.hyperstate.exceptions.EntityNotFoundException;
import com.google.common.base.Function;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.NotImplementedException;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.core.ParameterizedTypeReference;

public class WebDriverResolver
implements Resolver {
    private URI baseUri;
    private final WebDriver webDriver;

    public static ExpectedCondition<Boolean> angularHasFinishedProcessing() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                String hasAngularFinishedScript = "var callback = arguments[arguments.length - 1];\nvar el = document.querySelector('html');\nif (!window.angular) {\n    callback('false')\n}\nif (angular.getTestability) {\n    angular.getTestability(el).whenStable(function(){callback('true')});\n} else {\n    if (!angular.element(el).injector()) {\n        callback('false')\n    }\n    var browser = angular.element(el).injector().get('$browser');\n    browser.notifyWhenNoOutstandingRequests(function(){callback('true')});\n}";
                JavascriptExecutor javascriptExecutor = (JavascriptExecutor)driver;
                String isProcessingFinished = javascriptExecutor.executeAsyncScript("var callback = arguments[arguments.length - 1];\nvar el = document.querySelector('html');\nif (!window.angular) {\n    callback('false')\n}\nif (angular.getTestability) {\n    angular.getTestability(el).whenStable(function(){callback('true')});\n} else {\n    if (!angular.element(el).injector()) {\n        callback('false')\n    }\n    var browser = angular.element(el).injector().get('$browser');\n    browser.notifyWhenNoOutstandingRequests(function(){callback('true')});\n}", new Object[0]).toString();
                return Boolean.valueOf(isProcessingFinished);
            }
        };
    }

    public WebDriverResolver(URI baseUri, WebDriver webDriver) {
        this.baseUri = baseUri;
        this.webDriver = webDriver;
    }

    public CompletableFuture<CreatedEntity> create(WebDriverAddress address, Map<String, Object> filteredParameters) {
        return CompletableFuture.supplyAsync(this.create(filteredParameters));
    }

    private Supplier<CreatedEntity> create(Map<String, Object> filteredParameters) {
        return () -> {
            WebElement form = (WebElement)new WebDriverWait(this.getWebDriver(), 5L).until((Function)ExpectedConditions.presenceOfElementLocated((By)By.name((String)((String)filteredParameters.get("action")))));
            List inputs = form.findElements(By.tagName((String)"input"));
            for (WebElement input : inputs) {
                Object value;
                String inputName = input.getAttribute("name");
                if (inputName == null || (value = filteredParameters.get(inputName)) == null) continue;
                input.sendKeys(new CharSequence[]{value.toString()});
            }
            form.findElement(By.cssSelector((String)"button[type='submit']")).click();
            WebDriverAddress newAddress = new WebDriverAddress(this, this.getWebDriver().findElement(By.tagName((String)"html")));
            CreatedEntity linkedEntity = new CreatedEntity(new Link((Address)newAddress, null, new String[0]));
            return linkedEntity;
        };
    }

    <E> E createProxy(Class<E> klass) {
        Enhancer e = this.initEnhancer(klass);
        Object proxy = e.create(new Class[0], new Object[0]);
        return (E)proxy;
    }

    public CompletableFuture<DeletedEntity> delete(WebDriverAddress address, Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            this.submitForm(address, parameters);
            return this.createProxy(DeletedEntity.class);
        });
    }

    public <T> CompletableFuture<T> get(WebDriverAddress address, Map<String, Object> filteredParameters, Class<T> type) {
        return CompletableFuture.supplyAsync(() -> {
            this.submitForm(address, filteredParameters);
            return this.createProxy(type);
        });
    }

    private void submitForm(WebDriverAddress address, Map<String, Object> parameters) {
        WebElement form = address.getWebElement();
        if ("form".equals(form.getTagName())) {
            for (WebElement input : form.findElements(By.tagName((String)"input"))) {
                Object value = parameters.get(input.getAttribute("name"));
                if (value == null) continue;
                input.sendKeys(new CharSequence[]{value.toString()});
            }
            form.findElement(By.cssSelector((String)"button[type='submit']")).click();
        } else {
            form.click();
        }
    }

    public <E extends EntityWrapper<?>> CompletableFuture<E> get(String path, Class<E> type) {
        return this.get(this.getBaseUri().resolve(path), type);
    }

    public <T> CompletableFuture<T> get(URI uri, Class<T> klass) {
        return CompletableFuture.supplyAsync(() -> {
            this.getWebDriver().get(uri.toString());
            List elements404 = this.getWebDriver().findElements(By.className((String)"status404")).stream().filter(WebElement::isDisplayed).collect(Collectors.toList());
            if (elements404.isEmpty()) {
                return this.createProxy(klass);
            }
            throw new EntityNotFoundException();
        });
    }

    private URI getBaseUri() {
        return this.baseUri;
    }

    <E> Enhancer initEnhancer(Class<E> klass) {
        Enhancer e = new Enhancer();
        WebDriverResolver resolver = this;
        e.setClassLoader(this.getClass().getClassLoader());
        e.setSuperclass(klass);
        e.setCallback(new WebDriverEntityInterceptor(resolver));
        return e;
    }

    public CompletableFuture<UpdatedEntity> update(WebDriverAddress address, Map<String, Object> parameters) {
        return CompletableFuture.supplyAsync(() -> {
            this.submitForm(address, parameters);
            return new UpdatedEntity(new Link((Address)new WebDriverAddress(this, this.webDriver.findElement(By.tagName((String)"html")))));
        });
    }

    public <T> CompletableFuture<T> get(WebDriverAddress address, Class<T> type) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.get(address, parameters, type);
    }

    public <T> CompletableFuture<T> get(WebDriverAddress address, ParameterizedTypeReference<T> type) {
        throw new NotImplementedException("TODO");
    }

    WebDriver getWebDriver() {
        return this.webDriver;
    }

    public CompletableFuture<EntityWrapper<?>> get(WebDriverAddress address) {
        ParameterizedTypeReference type = new ParameterizedTypeReference<EntityWrapper<?>>(){};
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.get(address, parameters, type);
    }

    private CompletableFuture<EntityWrapper<?>> get(WebDriverAddress address, Map<String, Object> parameters, ParameterizedTypeReference<EntityWrapper<?>> type) {
        return CompletableFuture.supplyAsync(() -> {
            this.submitForm(address, parameters);
            return this.createProxy(type);
        });
    }

    private EntityWrapper<?> createProxy(ParameterizedTypeReference<EntityWrapper<?>> type) {
        Enhancer e = this.initEnhancer(EntityWrapper.class);
        EntityWrapper proxy = (EntityWrapper)e.create(new Class[0], new Object[0]);
        return proxy;
    }
}

