/*
 * Decompiled with CFR 0.152.
 */
package au.com.mountainpass.hyperstate.client.webdriver;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"ui-integration"})
public class WebDriverFactory {
    @Value(value="${webdriver.driver:org.openqa.selenium.firefox.FirefoxDriver}")
    String driverClassName;
    @Value(value="${webdriver.window.height:768}")
    int height;
    @Value(value="${webdriver.window.width:1024}")
    int width;

    private WebDriver createDriver(DesiredCapabilities cap) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> driverClass = Class.forName(this.driverClassName);
        Constructor<?> constructor = driverClass.getConstructor(Capabilities.class);
        return (WebDriver)constructor.newInstance(cap);
    }

    public WebDriver createWebDriver() throws ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        DesiredCapabilities cap = new DesiredCapabilities();
        WebDriver driver = this.createDriver(cap);
        driver.manage().window().setSize(new Dimension(this.width, this.height));
        return driver;
    }
}

