/*
 * Decompiled with CFR 0.152.
 */
package au.com.dardle.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.Pools;
import android.support.v7.widget.TintTypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import au.com.dardle.widget.BadgeItem;
import au.com.dardle.widget.R;
import java.util.ArrayList;

public class BadgeLayout
extends FrameLayout {
    private static final Pools.Pool<Badge> sBadgePool = new Pools.SynchronizedPool(16);
    private final Pools.Pool<BadgeView> mBadgeViewPool = new Pools.SimplePool(12);
    private final ArrayList<Badge> mBadges = new ArrayList();
    private final ArrayList<OnBadgeClickedListener> mOnBadgeClickedListeners = new ArrayList();
    private final View.OnClickListener mClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            if (view instanceof BadgeView) {
                BadgeView badgeView = (BadgeView)view;
                Badge badge = badgeView.mBadge;
                for (int i = BadgeLayout.this.mOnBadgeClickedListeners.size() - 1; i >= 0; --i) {
                    ((OnBadgeClickedListener)BadgeLayout.this.mOnBadgeClickedListeners.get(i)).onBadgeClicked(badge);
                }
            }
        }
    };
    private int mItemSpacing;
    @NonNull
    private final LinearLayout mContentContainer;

    public BadgeLayout(Context context) {
        this(context, null);
    }

    public BadgeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BadgeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContentContainer = new LinearLayout(context);
        this.mContentContainer.setOrientation(0);
        super.addView((View)this.mContentContainer, 0, new ViewGroup.LayoutParams(-2, -2));
        TintTypedArray tintTypedArray = TintTypedArray.obtainStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.BadgeLayout);
        this.mItemSpacing = tintTypedArray.getDimensionPixelSize(R.styleable.BadgeLayout_itemSpacing, 8);
    }

    public void addView(View child) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index) {
        this.addViewInternal(child);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.addViewInternal(child);
    }

    @NonNull
    public Badge newBadge() {
        Badge badge = (Badge)sBadgePool.acquire();
        if (badge == null) {
            badge = new Badge();
        }
        badge.mParent = this;
        badge.mView = this.createBadgeView(badge);
        return badge;
    }

    public void addBadge(@NonNull Badge badge) {
        if (badge.mParent != this) {
            throw new IllegalArgumentException("Badge belongs to a different BadgeLayout");
        }
        this.addBadgeView(badge);
        this.configureBadge(badge);
    }

    public void removeAllBadges() {
        this.mContentContainer.removeAllViews();
        this.mBadges.clear();
    }

    public void setItemSpacing(int spacing) {
        this.mItemSpacing = spacing;
        for (int i = 1; i < this.mBadges.size(); ++i) {
            Badge badge = this.mBadges.get(i);
            BadgeView view = badge.mView;
            if (view == null) continue;
            LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
            layoutParams.leftMargin = this.mItemSpacing;
        }
    }

    public void addOnBadgeClickedListener(@NonNull OnBadgeClickedListener onBadgeClickedListener) {
        if (!this.mOnBadgeClickedListeners.contains(onBadgeClickedListener)) {
            this.mOnBadgeClickedListeners.add(onBadgeClickedListener);
        }
    }

    public void removeOnBadgeClickedListener(@NonNull OnBadgeClickedListener onBadgeClickedListener) {
        this.mOnBadgeClickedListeners.remove(onBadgeClickedListener);
    }

    private void addViewInternal(View child) {
        if (!(child instanceof BadgeItem)) {
            throw new IllegalArgumentException("Only BadgeItem instances can be added to BadgeLayout");
        }
        this.addBadgeFromItemView((BadgeItem)child);
    }

    private void addBadgeFromItemView(@NonNull BadgeItem badgeItem) {
        Badge badge = this.newBadge();
        badge.setText(badgeItem.mText);
        badge.setIcon(badgeItem.mIcon);
        badge.setEnabled(badgeItem.isEnabled());
        badge.setSelected(badgeItem.isSelected());
        this.addBadge(badge);
    }

    private BadgeView createBadgeView(@NonNull Badge badge) {
        BadgeView badgeView = (BadgeView)((Object)this.mBadgeViewPool.acquire());
        if (badgeView == null) {
            badgeView = new BadgeView(this.getContext());
        }
        badgeView.setBadge(badge);
        return badgeView;
    }

    private void addBadgeView(Badge badge) {
        BadgeView badgeView = badge.mView;
        if (badgeView != null) {
            if (badgeView.getParent() != null) {
                this.mContentContainer.removeView((View)badgeView);
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            if (this.mContentContainer.getChildCount() > 0) {
                layoutParams.leftMargin = this.mItemSpacing;
            }
            badgeView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mContentContainer.addView((View)badgeView);
        }
    }

    private void configureBadge(Badge badge) {
        this.mBadges.add(badge);
        if (badge.mView != null) {
            badge.mView.setOnClickListener(this.mClickListener);
        }
    }

    private class BadgeView
    extends LinearLayout {
        @Nullable
        private Badge mBadge;
        @NonNull
        private final ImageView mImageView;
        @NonNull
        private final TextView mTextView;

        public BadgeView(Context context) {
            super(context);
            this.setOrientation(1);
            this.setGravity(17);
            this.mImageView = new ImageView(context);
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            this.addView((View)this.mImageView);
            this.mTextView = new TextView(context);
            this.mTextView.setLines(1);
            this.mTextView.setEllipsize(TextUtils.TruncateAt.END);
            this.mTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            this.addView((View)this.mTextView);
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            this.mImageView.setSelected(selected);
            this.mTextView.setSelected(selected);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.mImageView.setEnabled(enabled);
            this.mTextView.setEnabled(enabled);
        }

        private void setBadge(Badge badge) {
            this.mBadge = badge;
            this.update();
        }

        private void update() {
            if (this.mBadge != null) {
                this.mImageView.setImageDrawable(this.mBadge.mIcon);
                this.mTextView.setText(this.mBadge.mText);
                this.setSelected(this.mBadge.mSelected);
                this.setEnabled(this.mBadge.mEnabled);
            } else {
                this.mImageView.setImageDrawable(null);
                this.mImageView.setVisibility(8);
                this.mTextView.setText((CharSequence)"");
                this.mTextView.setVisibility(8);
                this.setSelected(false);
                this.setEnabled(false);
            }
        }
    }

    public static final class Badge {
        @Nullable
        private Drawable mIcon;
        @Nullable
        private CharSequence mText;
        private boolean mSelected = false;
        private boolean mEnabled = true;
        @Nullable
        private BadgeLayout mParent;
        @Nullable
        private BadgeView mView;

        @NonNull
        public Badge setText(@Nullable CharSequence text) {
            this.mText = text;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setSelected(boolean selected) {
            this.mSelected = selected;
            this.updateView();
            return this;
        }

        @NonNull
        public Badge setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            this.updateView();
            return this;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        private void updateView() {
            if (this.mView != null) {
                this.mView.update();
            }
        }
    }

    public static interface OnBadgeClickedListener {
        public void onBadgeClicked(Badge var1);
    }
}

