/*
 * Decompiled with CFR 0.152.
 */
package au.com.anthonybruno.record.factory;

import au.com.anthonybruno.annotation.Generation;
import au.com.anthonybruno.generator.GeneratedValue;
import au.com.anthonybruno.generator.Generator;
import au.com.anthonybruno.record.DefaultRecords;
import au.com.anthonybruno.record.Record;
import au.com.anthonybruno.record.Records;
import au.com.anthonybruno.record.RowRecord;
import au.com.anthonybruno.record.factory.RecordFactory;
import au.com.anthonybruno.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class ClassRecordFactory
implements RecordFactory {
    private final Class<?> classToUse;

    public ClassRecordFactory(Class<?> classToUse) {
        this.classToUse = classToUse;
    }

    @Override
    public Records generateRecords(int numToGenerate) {
        Field[] fields = this.classToUse.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        ArrayList<Record> records = new ArrayList<Record>();
        for (int i = 0; i < numToGenerate; ++i) {
            records.add(this.generateRecord(fields));
        }
        return new DefaultRecords(fieldNames, records);
    }

    private Record generateRecord(Field[] fields) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Field field : fields) {
            list.add(this.generateValue(field));
        }
        return new RowRecord(list);
    }

    private Object generateValue(Field field) {
        Generation generatorAnnotation = field.getAnnotation(Generation.class);
        if (generatorAnnotation != null) {
            Generator generator = ReflectionUtils.buildWithNoArgConstructor(generatorAnnotation.value());
            return generator.generate();
        }
        return new GeneratedValue(field.getType()).get();
    }
}

