/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.reflect;

import at.molindo.thirdparty.org.springframework.core.GenericTypeResolver;
import at.molindo.utils.collections.ArrayUtils;
import java.lang.reflect.Type;
import java.util.Set;

public class ClassUtils {
    private ClassUtils() {
    }

    public static Class<?> getTypeArgument(Class<?> cls, Class<?> genericCls) {
        return ArrayUtils.first(ClassUtils.getTypeArguments(cls, genericCls));
    }

    public static Class<?>[] getTypeArguments(Class<?> cls, Class<?> genericCls) {
        return GenericTypeResolver.resolveTypeArguments(cls, genericCls);
    }

    public static Class<?> toClass(Class<?> declaringCls, Type type) {
        return GenericTypeResolver.extractClass(declaringCls, type);
    }

    public static boolean isAssignable(Class<?> cls, Set<Class<?>> classes) {
        if (cls == null || classes.isEmpty()) {
            return false;
        }
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableToAll(Class<?> cls, Set<Class<?>> classes) {
        if (cls == null) {
            return false;
        }
        for (Class<?> c : classes) {
            if (c.isAssignableFrom(cls)) continue;
            return false;
        }
        return true;
    }
}

