/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.data;

import at.molindo.utils.collections.IteratorUtils;
import at.molindo.utils.data.ObjectUtils;
import at.molindo.utils.data.Pair;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean empty(String string) {
        return string == null || string.isEmpty();
    }

    public static String trim(String string) {
        return string == null ? null : string.trim();
    }

    public static String trimLeading(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int length = string.length();
        for (i = 0; i < length && string.charAt(i) == ' '; ++i) {
        }
        return string.substring(i);
    }

    public static String trimTrailing(String string) {
        int i;
        if (string == null) {
            return null;
        }
        for (i = string.length() - 1; i >= 0 && string.charAt(i) == ' '; --i) {
        }
        return string.substring(0, i + 1);
    }

    public static String sub(String s, int length) {
        return StringUtils.sub(s, "", length);
    }

    public static String sub(String s, String suffix, int maxLength) {
        if (suffix == null) {
            suffix = "";
        }
        if (maxLength < suffix.length()) {
            throw new IllegalArgumentException("suffix ('" + suffix + "') must not be longer than maxLength (" + maxLength + ")");
        }
        if (s == null || s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength - suffix.length()) + suffix;
    }

    public static String afterFirst(String string, String delim) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(delim);
        if (index == -1) {
            return "";
        }
        return string.substring(index + delim.length());
    }

    public static String afterLast(String string, String delim) {
        if (string == null) {
            return null;
        }
        int index = string.lastIndexOf(delim);
        if (index == -1) {
            return "";
        }
        return string.substring(index + delim.length());
    }

    public static String beforeFirst(String string, String delim) {
        if (string == null) {
            return null;
        }
        int index = string.indexOf(delim);
        if (index == -1) {
            return "";
        }
        return string.substring(0, index);
    }

    public static String beforeLast(String string, String delim) {
        if (string == null) {
            return null;
        }
        int index = string.lastIndexOf(delim);
        if (index == -1) {
            return "";
        }
        return string.substring(0, index);
    }

    public static String startWith(String string, String prefix) {
        if (StringUtils.empty(string)) {
            return prefix;
        }
        if (string.startsWith(prefix)) {
            return string;
        }
        return prefix + string;
    }

    public static String endWith(String string, String suffix) {
        if (StringUtils.empty(string)) {
            return suffix;
        }
        if (string.endsWith(suffix)) {
            return string;
        }
        return string + suffix;
    }

    public static String trailing(String string, String suffix) {
        if (string == null) {
            return null;
        }
        return suffix == null || string.endsWith(suffix) ? string : string + suffix;
    }

    public static String leading(String string, String prefix) {
        if (string == null) {
            return null;
        }
        return prefix == null || string.startsWith(prefix) ? string : prefix + string;
    }

    public static String stripTrailing(String string, String suffix) {
        if (string == null) {
            return null;
        }
        if (suffix != null && string.endsWith(suffix)) {
            return string.substring(0, string.length() - suffix.length());
        }
        return string;
    }

    public static String stripLeading(String string, String prefix) {
        if (string == null) {
            return null;
        }
        if (prefix != null && string.startsWith(prefix)) {
            return string.substring(prefix.length());
        }
        return string;
    }

    public static int split(String string, String delim, String[] a) {
        if (a.length == 0) {
            throw new IllegalArgumentException();
        }
        int idx = 0;
        for (String s : StringUtils.split(string, delim)) {
            a[idx++] = s;
        }
        return idx;
    }

    public static Pair<String, String> pair(String string, String delim) {
        if (string == null) {
            return Pair.pair("", "");
        }
        int idx = string.indexOf(delim);
        if (idx < 0) {
            return Pair.pair(string, "");
        }
        return Pair.pair(string.substring(0, idx), string.substring(idx + 1));
    }

    public static boolean equals(String s1, String s2) {
        return ObjectUtils.equals(s1, s2);
    }

    public static String upperFirst(String s) {
        return StringUtils.upperFirst(s, Locale.getDefault());
    }

    public static String upperFirst(String s, Locale locale) {
        if (s == null || s.length() < 1) {
            return s;
        }
        return s.substring(0, 1).toUpperCase(locale) + s.substring(1);
    }

    public static String lowerFirst(String s) {
        return StringUtils.lowerFirst(s, Locale.getDefault());
    }

    public static String lowerFirst(String s, Locale locale) {
        if (s == null || s.length() < 1) {
            return s;
        }
        return s.substring(0, 1).toLowerCase(locale) + s.substring(1);
    }

    public static Iterable<String> split(String string, String split) {
        return StringUtils.split(string, split, Integer.MAX_VALUE);
    }

    public static Iterable<String> split(final String string, final String split, final int max) {
        if (string == null) {
            throw new NullPointerException("string");
        }
        if (split == null) {
            throw new NullPointerException("split");
        }
        if (split.isEmpty()) {
            throw new IllegalArgumentException("split must not be empty");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("max must be >= 1, was " + max);
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int _count = 0;
                    private int _pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this._pos >= 0;
                    }

                    @Override
                    public String next() {
                        String str;
                        int next;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int n = next = ++this._count == max ? -1 : string.indexOf(split, this._pos);
                        if (next > 0) {
                            str = string.substring(this._pos, next);
                            this._pos = next + split.length();
                        } else {
                            str = string.substring(this._pos);
                            this._pos = -1;
                        }
                        return str;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static String join(String separator, Object ... fragments) {
        return StringUtils.join(separator, Arrays.asList(fragments));
    }

    public static String join(String separator, Iterable<?> fragments) {
        return StringUtils.join(separator, IteratorUtils.iterator(fragments));
    }

    public static String join(String separator, Iterator<?> fragments) {
        if (!fragments.hasNext()) {
            return "";
        }
        if (separator == null) {
            separator = "";
        }
        StringBuffer buf = new StringBuffer(128);
        do {
            String fragment;
            if (StringUtils.empty(fragment = StringUtils.string(fragments.next()))) continue;
            buf.append(fragment).append(separator);
        } while (fragments.hasNext());
        if (buf.length() > 0) {
            buf.setLength(buf.length() - separator.length());
        }
        return buf.toString();
    }

    public static String string(Object o) {
        return o == null ? null : o.toString();
    }
}

