/*
 * Decompiled with CFR 0.152.
 */
package at.molindo.utils.collections;

import at.molindo.utils.collections.IteratorUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class IteratorChain<T>
implements Iterator<T> {
    private final Iterator<Iterator<T>> _iterators;
    private Iterator<T> _next;
    private Iterator<T> _last;

    public static <T> IteratorChain<T> chainIterables(Iterable<? extends Iterable<T>> iterables) {
        return new IteratorChain(IteratorUtils.iterators(iterables));
    }

    public static <T> IteratorChain<T> chainIterables(Iterator<? extends Iterable<T>> iterables) {
        return new IteratorChain(IteratorUtils.iterators(iterables));
    }

    public IteratorChain(Iterable<Iterator<T>> iterators) {
        this(iterators.iterator());
    }

    public IteratorChain(Iterator<Iterator<T>> iterator) {
        this._iterators = IteratorUtils.list(iterator).iterator();
        if (this._iterators.hasNext()) {
            this._next = this._iterators.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this._next == null) {
            return false;
        }
        if (this._next.hasNext()) {
            return true;
        }
        if (this._iterators.hasNext()) {
            this._next = this._iterators.next();
            return this.hasNext();
        }
        this._next = null;
        return false;
    }

    @Override
    public T next() {
        if (this._next == null) {
            throw new NoSuchElementException();
        }
        T o = this._next.next();
        this._last = this._next;
        return o;
    }

    @Override
    public void remove() {
        if (this._last == null) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this._last.remove();
    }
}

