/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.rt;

public class DelayCalculator {
    public static final float DEFAULT_EPSILON = 0.05f;
    public static final long MAX_INTERVAL = 1000000000L;

    private DelayCalculator() {
    }

    public static Result calculate(long nanoseconds) {
        return DelayCalculator.calculate(nanoseconds, 0.05f);
    }

    public static Result calculate(long nanoseconds, float epsilon) {
        if (epsilon <= 0.0f || epsilon >= 1.0f) {
            throw new IllegalArgumentException("0 < epsilon < 1 not satisfied");
        }
        long max_divider = (int)(1.0 / (double)epsilon);
        if (nanoseconds < max_divider) {
            return new Result(nanoseconds, 1L);
        }
        long interval = Math.min(1000000000L, nanoseconds / max_divider);
        long correction = nanoseconds / interval;
        return new Result(interval, correction);
    }

    public static class Result {
        private final long tickNanosecondsInterval;
        private final long delay;

        private Result(long tickNanosecondsInterval, long delay) {
            this.tickNanosecondsInterval = tickNanosecondsInterval;
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }

        public long getTickNanosecondsInterval() {
            return this.tickNanosecondsInterval;
        }
    }
}

