/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.proxy;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class RateCalculator {
    public static final float MIN_RATE = 7.6E-10f;
    public static final float MAX_RATE = 8.7E13f;
    public static final int NS_PER_S = 1000000000;
    public static final int MIN_INTERVAL_NS = 100;
    public static final int MAX_INTERVAL_NS = 1000000000;
    public static final int MAX_BYTES_PER_TICK = 0xA00000;
    public static final int SCALE = 70;
    public static final RoundingMode ROUND = RoundingMode.HALF_UP;
    public static final double MAX_ERROR = 0.005;

    private RateCalculator() {
    }

    public static Result calculate(float rateBytesPerSecond) {
        return RateCalculator.calculate(rateBytesPerSecond, 100);
    }

    public static Result calculate(float rateBytesPerSecond, int minInterval) {
        BigDecimal B_MIN = BigDecimal.ONE;
        BigDecimal B_MAX = BigDecimal.valueOf(0xA00000L);
        BigDecimal I_MIN = BigDecimal.valueOf(minInterval);
        BigDecimal I_MAX = BigDecimal.valueOf(1000000000L);
        BigDecimal Id_MAX = BigDecimal.valueOf(Integer.MAX_VALUE);
        BigDecimal ONEG = BigDecimal.valueOf(1000000000L);
        BigDecimal TWO = BigDecimal.valueOf(2L);
        BigDecimal E = BigDecimal.valueOf(Math.E);
        BigDecimal R = BigDecimal.valueOf(rateBytesPerSecond).divide(ONEG, 70, ROUND);
        BigDecimal I = I_MAX;
        BigDecimal B = R.multiply(I);
        BigDecimal ERROR_MAX = BigDecimal.valueOf(0.005);
        BigDecimal R_set = BigDecimal.valueOf(rateBytesPerSecond).divide(ONEG, 70, ROUND);
        if (B.compareTo(B_MIN) <= 0) {
            B = BigDecimal.ONE;
            I = B.divide(R, 70, ROUND);
            BigDecimal Id = BigDecimal.ONE;
            while (true) {
                if (I.compareTo(I_MAX) > 0) {
                    I = I.divide(E, 70, ROUND);
                    Id = Id.multiply(E);
                    continue;
                }
                if (Id.compareTo(Id_MAX) > 0) {
                    throw new IllegalArgumentException("rate too low (" + rateBytesPerSecond + "): prescaler too high");
                }
                BigDecimal B_int = BigDecimal.valueOf(B.setScale(0, ROUND).intValueExact());
                BigDecimal I_int = BigDecimal.valueOf(I.setScale(0, ROUND).intValueExact());
                BigDecimal Id_int = BigDecimal.valueOf(Id.setScale(0, ROUND).intValueExact());
                BigDecimal R_eff = B_int.divide(I_int, 70, ROUND).divide(Id_int, 70, ROUND);
                BigDecimal ERROR = R_eff.divide(R_set, 70, ROUND).subtract(BigDecimal.ONE).abs();
                if (ERROR.compareTo(ERROR_MAX) < 0) break;
                I = I.multiply(E);
                B = B.multiply(E);
            }
            return new Result(B.setScale(0, ROUND).intValueExact(), Id.setScale(0, ROUND).intValueExact(), I.setScale(0, ROUND).intValueExact());
        }
        BigDecimal Id = BigDecimal.ONE;
        while (true) {
            if (I.compareTo(I_MAX) > 0) {
                I = I.divide(E, 70, ROUND);
                Id = Id.multiply(E);
                continue;
            }
            while (B.compareTo(B_MAX) > 0) {
                B = B.divide(TWO, 70, ROUND);
                I = I.divide(TWO, 70, ROUND);
            }
            if (I.compareTo(BigDecimal.ONE) < 0) {
                throw new IllegalArgumentException("rate too high (" + rateBytesPerSecond + "): interval too low");
            }
            BigDecimal B_int = BigDecimal.valueOf(B.setScale(0, ROUND).intValueExact());
            BigDecimal I_int = BigDecimal.valueOf(I.setScale(0, ROUND).intValueExact());
            BigDecimal Id_int = BigDecimal.valueOf(Id.setScale(0, ROUND).intValueExact());
            BigDecimal R_eff = B_int.divide(I_int, 70, ROUND).divide(Id_int, 70, ROUND);
            BigDecimal ERROR = R_eff.divide(R_set, 70, ROUND).subtract(BigDecimal.ONE).abs();
            if (ERROR.compareTo(ERROR_MAX) < 0) break;
            I = I.multiply(E);
            B = B.multiply(E);
        }
        if (I.compareTo(I_MIN) < 0) {
            throw new IllegalArgumentException("rate too high (" + rateBytesPerSecond + "): interval too low");
        }
        return new Result(B.setScale(0, ROUND).intValueExact(), Id.setScale(0, ROUND).intValueExact(), I.setScale(0, ROUND).intValueExact());
    }

    public static class Result {
        private final int bytesPerTick;
        private final int prescale;
        private final int tickNanosecondInterval;

        public Result(int bytesPerTick, int prescale, int tickNanosecondInterval) {
            this.bytesPerTick = bytesPerTick;
            this.prescale = prescale;
            this.tickNanosecondInterval = tickNanosecondInterval;
        }

        public int getBytesPerTick() {
            return this.bytesPerTick;
        }

        public int getPrescale() {
            return this.prescale;
        }

        public int getTickNanosecondsInterval() {
            return this.tickNanosecondInterval;
        }
    }
}

