/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.wechat.pay.autoconfigure;

import app.myoss.wechat.pay.autoconfigure.WeChatPayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WeChatPayServiceOkHttpImpl;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@EnableConfigurationProperties(value={WeChatPayProperties.class})
@ConditionalOnProperty(prefix="wechat.pay", value={"enabled"}, matchIfMissing=false)
@Configuration
public class WeChatPayAutoConfiguration {
    @ConditionalOnMissingBean
    @Bean
    public WxPayService wxPayService(WeChatPayProperties weChatPayProperties) {
        WeChatPayProperties.WeChatMp config = weChatPayProperties.getConfig();
        WxPayConfig payConfig = new WxPayConfig();
        WeChatPayServiceOkHttpImpl wxPayService = new WeChatPayServiceOkHttpImpl();
        wxPayService.setConfig(payConfig);
        payConfig.setAppId(config.getAppId());
        payConfig.setMchId(config.getMchId());
        payConfig.setMchKey(config.getMchKey());
        payConfig.setNotifyUrl(config.getNotifyUrl());
        payConfig.setTradeType(config.getTradeType());
        return wxPayService;
    }
}

