/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.sequence.spring.boot.autoconfigure;

import app.myoss.cloud.mybatis.table.TableMetaObject;
import app.myoss.cloud.sequence.Sequence;
import app.myoss.cloud.sequence.SequenceRepository;
import app.myoss.cloud.sequence.impl.DefaultSequenceImpl;
import app.myoss.cloud.sequence.impl.RdsSequenceRepository;
import app.myoss.cloud.sequence.spring.boot.autoconfigure.RdsSequenceProperties;
import app.myoss.cloud.sequence.utils.DefaultSequenceUtils;
import com.alibaba.fastjson.JSON;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@EnableConfigurationProperties(value={RdsSequenceProperties.class})
@ConditionalOnProperty(prefix="myoss-cloud.sequence.rds", value={"enabled"}, matchIfMissing=false)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Configuration
public class RdsSequenceAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RdsSequenceAutoConfiguration.class);
    private RdsSequenceProperties properties;

    public RdsSequenceAutoConfiguration(RdsSequenceProperties properties) {
        this.properties = properties;
        if (log.isInfoEnabled()) {
            log.info("init RdsSequence auto configuration, properties: {}", (Object)JSON.toJSONString((Object)properties));
        }
    }

    @Primary
    @ConditionalOnMissingBean
    @Bean(initMethod="init")
    public RdsSequenceRepository rdsSequenceRepository(ApplicationContext applicationContext) {
        return DefaultSequenceUtils.buildRdsSequenceRepository(applicationContext, this.properties, false);
    }

    @ConditionalOnClass(value={Sequence.class, TableMetaObject.class})
    @ConditionalOnBean(value={SequenceRepository.class})
    @ConditionalOnMissingBean(name={"initDefaultSequence"})
    @Bean
    public Optional<DefaultSequenceImpl> initDefaultSequence(SequenceRepository sequenceRepository, ApplicationContext applicationContext) {
        DefaultSequenceUtils.initDefaultSequence(TableMetaObject.getSequenceBeanMap().values(), sequenceRepository, applicationContext);
        return Optional.empty();
    }
}

