/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.type;

import app.myoss.cloud.mybatis.type.EnumValue;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import lombok.NonNull;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EnumValueTypeHandler<E extends Enum<?>>
extends BaseTypeHandler<EnumValue> {
    @NonNull
    private final Class<E> type;

    public void setNonNullParameter(PreparedStatement ps, int i, EnumValue parameter, JdbcType jdbcType) throws SQLException {
        if (jdbcType == null) {
            ps.setObject(i, parameter.getDbValue());
        } else {
            ps.setObject(i, parameter.getDbValue(), jdbcType.TYPE_CODE);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object value = rs.getObject(columnName);
        return EnumValueTypeHandler.getEnum(this.type, value);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex);
        return EnumValueTypeHandler.getEnum(this.type, value);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object value = cs.getObject(columnIndex);
        return EnumValueTypeHandler.getEnum(this.type, value);
    }

    private static <E extends Enum<?>> E getEnum(Class<E> enumClass, Object value) {
        Enum[] enumConstants;
        if (value == null) {
            return null;
        }
        for (Enum enumConstant : enumConstants = (Enum[])enumClass.getEnumConstants()) {
            if (!Objects.equals(value, ((EnumValue)((Object)enumConstant)).getDbValue())) continue;
            return (E)enumConstant;
        }
        return null;
    }

    public EnumValueTypeHandler(@NonNull Class<E> type) {
        if (type == null) {
            throw new NullPointerException("type is marked @NonNull but is null");
        }
        this.type = type;
    }
}

