/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.sequence.impl;

import app.myoss.cloud.sequence.SequenceRange;
import app.myoss.cloud.sequence.SequenceRepository;
import app.myoss.cloud.sequence.exception.SequenceException;
import app.myoss.cloud.sequence.utils.RandomSequenceUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class RdsSequenceRepository
implements SequenceRepository {
    private static final Logger log = LoggerFactory.getLogger(RdsSequenceRepository.class);
    public static final int DEFAULT_INNER_STEP = 1000;
    public static final int DEFAULT_RETRY_TIMES = 2;
    public static final String DEFAULT_TABLE_NAME = "sequence";
    public static final String DEFAULT_NAME_COLUMN_NAME = "name";
    public static final String DEFAULT_VALUE_COLUMN_NAME = "value";
    public static final String DEFAULT_GMT_CREATED_COLUMN_NAME = "gmt_created";
    public static final String DEFAULT_GMT_MODIFIED_COLUMN_NAME = "gmt_modified";
    public static final int DEFAULT_DATA_SOURCE_COUNT = 2;
    public static final Boolean DEFAULT_ADJUST = false;
    private static final long DELTA = 100000000L;
    private List<String> dbGroupKeys;
    private Map<String, DataSource> dataSourceMap;
    private int dataSourceCount = 2;
    private boolean adjust = DEFAULT_ADJUST;
    private int retryTimes = 2;
    private int innerStep = 1000;
    private int outStep = 1000;
    private String tableName = "sequence";
    private String nameColumnName = "name";
    private String valueColumnName = "value";
    private String gmtCreatedColumnName = "gmt_created";
    private String gmtModifiedColumnName = "gmt_modified";
    private final ReentrantLock lock = new ReentrantLock();
    protected volatile boolean isInit = false;
    private volatile String selectSql;
    private volatile String updateSql;
    private volatile String insertSql;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new SequenceException("interrupt", e);
        }
        try {
            if (this.isInit) {
                return;
            }
            if (CollectionUtils.isEmpty(this.dataSourceMap)) {
                throw new NullPointerException("dataSourceMap is empty");
            }
            if (CollectionUtils.isEmpty(this.dbGroupKeys)) {
                this.dbGroupKeys = new ArrayList<String>(this.dataSourceMap.keySet());
            }
            if (this.dbGroupKeys.size() >= this.dataSourceCount) {
                this.dataSourceCount = this.dbGroupKeys.size();
            } else {
                for (int i = this.dbGroupKeys.size(); i < this.dataSourceCount; ++i) {
                    this.dbGroupKeys.add(this.dataSourceCount + "-OFF");
                }
            }
            this.outStep = this.innerStep * this.dataSourceCount;
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append("\u521d\u59cb\u5316\u5b8c\u6210\uff1a").append(System.lineSeparator());
            sb.append("innerStep: ").append(this.innerStep).append(System.lineSeparator());
            sb.append("dataSource: ").append(this.dataSourceCount).append("\u4e2a: ");
            for (String str : this.dbGroupKeys) {
                sb.append("[").append(str).append("]\u3001");
            }
            sb.append(System.lineSeparator());
            sb.append("adjust\uff1a").append(this.adjust).append(System.lineSeparator());
            sb.append("retryTimes: ").append(this.retryTimes).append(System.lineSeparator());
            sb.append("tableName: ").append(this.tableName).append(System.lineSeparator());
            sb.append("nameColumnName: ").append(this.nameColumnName).append(System.lineSeparator());
            sb.append("valueColumnName: ").append(this.valueColumnName).append(System.lineSeparator());
            sb.append("gmtCreatedColumnName: ").append(this.gmtCreatedColumnName).append(System.lineSeparator());
            sb.append("gmtModifiedColumnName: ").append(this.gmtModifiedColumnName).append(System.lineSeparator());
            log.info(sb.toString());
        }
        finally {
            this.isInit = true;
            this.lock.unlock();
        }
    }

    protected boolean isOffState(String groupKey) {
        return groupKey.toUpperCase().endsWith("-OFF");
    }

    protected boolean check(int index, long value) {
        return value % (long)this.outStep == (long)(index * this.innerStep);
    }

    @Override
    public void adjust(String name) {
        Objects.requireNonNull(name, "name is empty");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        for (int i = 0; i < this.dbGroupKeys.size(); ++i) {
            block8: {
                String key = this.dbGroupKeys.get(i);
                if (this.isOffState(key)) continue;
                try {
                    DataSource dataSource = this.dataSourceMap.get(key);
                    conn = dataSource.getConnection();
                    stmt = conn.prepareStatement(this.getSelectSql());
                    stmt.setString(1, name);
                    rs = stmt.executeQuery();
                    int item = 0;
                    while (rs.next()) {
                        ++item;
                        long value = rs.getLong(this.getValueColumnName());
                        if (this.check(i, value)) continue;
                        if (this.isAdjust()) {
                            this.adjustUpdate(i, value, name);
                            continue;
                        }
                        throw new SequenceException("\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u521d\u503c\u51fa\u9519\uff01\u8bf7\u8c03\u6574\u4f60\u7684\u6570\u636e\u5e93\uff0c\u6216\u8005\u542f\u52a8adjust\u5f00\u5173\u3002name = " + name + ", value = " + value);
                    }
                    if (item != 0) break block8;
                    if (this.isAdjust()) {
                        this.adjustInsert(i, name);
                        break block8;
                    }
                    throw new SequenceException("\u6570\u636e\u5e93\u4e2d\u672a\u914d\u7f6e\u8be5sequence\uff01\u8bf7\u5f80\u6570\u636e\u5e93\u4e2d\u63d2\u5165sequence\u8bb0\u5f55\uff0c\u6216\u8005\u542f\u52a8adjust\u5f00\u5173\u3002name = " + name);
                }
                catch (SQLException e) {
                    try {
                        throw new SequenceException("\u521d\u503c\u6821\u9a8c\u548c\u81ea\u9002\u5e94\u8fc7\u7a0b\u4e2d\u51fa\u9519.", e);
                    }
                    catch (Throwable throwable) {
                        RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                        throw throwable;
                    }
                }
            }
            RdsSequenceRepository.closeDbResource(rs, stmt, conn);
            continue;
        }
    }

    private void adjustUpdate(int index, long value, String name) throws SequenceException {
        long newValue = value - value % (long)this.outStep + (long)this.outStep + (long)(index * this.innerStep);
        Connection conn = null;
        PreparedStatement stmt = null;
        String key = this.dbGroupKeys.get(index);
        try {
            DataSource dataSource = this.dataSourceMap.get(key);
            conn = dataSource.getConnection();
            stmt = conn.prepareStatement(this.getUpdateSql());
            stmt.setLong(1, newValue);
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            stmt.setString(3, name);
            stmt.setLong(4, value);
            int affectedRows = stmt.executeUpdate();
            if (affectedRows == 0) {
                throw new SequenceException("failed to auto adjust init value at " + name + " update affectedRow =0");
            }
            log.info(key + " \u66f4\u65b0\u521d\u503c\u6210\u529f\uff01sequence Name\uff1a" + name + "\u66f4\u65b0\u8fc7\u7a0b\uff1a" + value + "-->" + newValue);
        }
        catch (SQLException e) {
            try {
                throw new SequenceException("\u51fa\u73b0SQLException\uff0c\u66f4\u65b0\u521d\u503c\u81ea\u9002\u5e94\u5931\u8d25\uff01dbGroupIndex: " + key + "\uff0csequence Name\uff1a" + name + "\u66f4\u65b0\u8fc7\u7a0b\uff1a" + value + "-->" + newValue, e);
            }
            catch (Throwable throwable) {
                RdsSequenceRepository.closeDbResource(null, stmt, conn);
                throw throwable;
            }
        }
        RdsSequenceRepository.closeDbResource(null, stmt, conn);
    }

    private void adjustInsert(int index, String name) throws SequenceException {
        long newValue = index * this.innerStep;
        Connection conn = null;
        PreparedStatement stmt = null;
        String key = this.dbGroupKeys.get(index);
        try {
            DataSource dataSource = this.dataSourceMap.get(key);
            conn = dataSource.getConnection();
            stmt = conn.prepareStatement(this.getInsertSql());
            stmt.setString(1, name);
            stmt.setLong(2, newValue);
            Timestamp now = new Timestamp(System.currentTimeMillis());
            stmt.setTimestamp(3, now);
            stmt.setTimestamp(4, now);
            int affectedRows = stmt.executeUpdate();
            if (affectedRows == 0) {
                throw new SequenceException("failed to auto adjust init value at " + name + " update affectedRow =0");
            }
            log.info(key + " \u63d2\u5165\u521d\u503c\u6210\u529f\uff01sequence Name: " + name + ", value: " + newValue);
        }
        catch (SQLException e) {
            try {
                throw new SequenceException("\u51fa\u73b0SQLException\uff0c\u63d2\u5165\u521d\u503c\u81ea\u9002\u5e94\u5931\u8d25\uff01dbGroupIndex: " + key + "\uff0csequence Name\uff1a" + name + "\uff0cvalue:" + newValue, e);
            }
            catch (Throwable throwable) {
                RdsSequenceRepository.closeDbResource(null, stmt, conn);
                throw throwable;
            }
        }
        RdsSequenceRepository.closeDbResource(null, stmt, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceRange nextRange(String name) throws SequenceException {
        Objects.requireNonNull(name, "name is empty");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int[] randomIntSequence = RandomSequenceUtils.randomIntSequence(this.dataSourceCount);
        for (int i = 0; i < this.retryTimes; ++i) {
            for (int j = 0; j < this.dataSourceCount; ++j) {
                long newValue;
                long oldValue;
                DataSource dataSource;
                String key;
                block18: {
                    int index;
                    block17: {
                        block16: {
                            index = randomIntSequence[j];
                            key = this.dbGroupKeys.get(index);
                            if (this.isOffState(key)) continue;
                            dataSource = this.dataSourceMap.get(key);
                            conn = dataSource.getConnection();
                            stmt = conn.prepareStatement(this.getSelectSql());
                            stmt.setString(1, name);
                            rs = stmt.executeQuery();
                            if (!rs.next()) {
                                throw new SequenceException("\u6570\u636e\u5e93\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684 sequence \u8bb0\u5f55\uff0cdbGroupIndex = " + key + ", name = " + name);
                            }
                            oldValue = rs.getLong(1);
                            if (oldValue >= 0L) break block16;
                            log.warn("Sequence value cannot be less than zero, value = {}, , please check table ", (Object)oldValue, (Object)this.getTableName());
                            RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                            continue;
                        }
                        if (oldValue <= 9223372036754775807L) break block17;
                        log.warn("Sequence value overflow, value = {}, please check table ", (Object)oldValue, (Object)this.getTableName());
                        RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                        continue;
                    }
                    try {
                        newValue = oldValue + (long)this.outStep;
                        if (this.check(index, newValue)) break block18;
                        if (this.isAdjust()) {
                            newValue = newValue - newValue % (long)this.outStep + (long)this.outStep + (long)(index * this.innerStep);
                            break block18;
                        }
                        throw new SequenceException("\u6570\u636e\u5e93\u4e2d\u914d\u7f6e\u7684\u521d\u503c\u51fa\u9519\uff01\u8bf7\u8c03\u6574\u4f60\u7684\u6570\u636e\u5e93\uff0c\u6216\u8005\u542f\u52a8adjust\u5f00\u5173\u3002dbGroupIndex = " + key + ", name = " + name + ", value = " + oldValue);
                    }
                    catch (SQLException e) {
                        try {
                            log.error("\u53d6\u8303\u56f4\u8fc7\u7a0b\u4e2d--\u67e5\u8be2\u51fa\u9519\uff01" + key + ": " + name, (Throwable)e);
                        }
                        catch (Throwable throwable) {
                            RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                            throw throwable;
                        }
                        RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                        continue;
                    }
                }
                RdsSequenceRepository.closeDbResource(rs, stmt, conn);
                try {
                    conn = dataSource.getConnection();
                    stmt = conn.prepareStatement(this.getUpdateSql());
                    stmt.setLong(1, newValue);
                    stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                    stmt.setString(3, name);
                    stmt.setLong(4, oldValue);
                    int affectedRows = stmt.executeUpdate();
                    if (affectedRows == 0) {
                        continue;
                    }
                }
                catch (SQLException e) {
                    log.error("\u53d6\u8303\u56f4\u8fc7\u7a0b\u4e2d--\u66f4\u65b0\u51fa\u9519\uff01" + key + ":" + name, (Throwable)e);
                    continue;
                }
                finally {
                    RdsSequenceRepository.closeDbResource(null, stmt, conn);
                }
                SequenceRange sequenceRange = new SequenceRange(newValue + 1L, newValue + (long)this.innerStep);
                log.debug("get new range, sequence name is: {}, range info: [{}]", (Object)name, (Object)sequenceRange);
                return sequenceRange;
            }
        }
        log.error("\u6240\u6709\u6570\u636e\u6e90\u90fd\u4e0d\u53ef\u7528\uff01\u4e14\u91cd\u8bd5" + this.retryTimes + "\u6b21\u540e\uff0c\u4ecd\u7136\u5931\u8d25!");
        throw new SequenceException("All dataSource failed to get value, retried too many times, retryTimes = " + this.retryTimes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInsertSql() {
        if (this.insertSql == null) {
            RdsSequenceRepository rdsSequenceRepository = this;
            synchronized (rdsSequenceRepository) {
                if (this.insertSql == null) {
                    this.insertSql = "insert into " + this.getTableName() + "(" + this.getNameColumnName() + "," + this.getValueColumnName() + "," + this.getGmtCreatedColumnName() + "," + this.getGmtModifiedColumnName() + ") values(?,?,?,?);";
                }
            }
        }
        return this.insertSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectSql() {
        if (this.selectSql == null) {
            RdsSequenceRepository rdsSequenceRepository = this;
            synchronized (rdsSequenceRepository) {
                if (this.selectSql == null) {
                    this.selectSql = "select " + this.getValueColumnName() + " from " + this.getTableName() + " where " + this.getNameColumnName() + " = ?";
                }
            }
        }
        return this.selectSql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUpdateSql() {
        if (this.updateSql == null) {
            RdsSequenceRepository rdsSequenceRepository = this;
            synchronized (rdsSequenceRepository) {
                if (this.updateSql == null) {
                    this.updateSql = "update " + this.getTableName() + " set " + this.getValueColumnName() + " = ?, " + this.getGmtModifiedColumnName() + " = ? where " + this.getNameColumnName() + " = ? and " + this.getValueColumnName() + " = ?";
                }
            }
        }
        return this.updateSql;
    }

    private static void closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                log.warn("Could not close JDBC ResultSet", (Throwable)e);
            }
            catch (Throwable e) {
                log.warn("Unexpected exception on closing JDBC ResultSet", e);
            }
        }
    }

    private static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                log.warn("Could not close JDBC Statement", (Throwable)e);
            }
            catch (Throwable e) {
                log.warn("Unexpected exception on closing JDBC Statement", e);
            }
        }
    }

    private static void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                log.warn("Could not close JDBC Connection", (Throwable)e);
            }
            catch (Throwable e) {
                log.warn("Unexpected exception on closing JDBC Connection", e);
            }
        }
    }

    private static void closeDbResource(ResultSet rs, Statement stmt, Connection conn) {
        RdsSequenceRepository.closeResultSet(rs);
        RdsSequenceRepository.closeStatement(stmt);
        RdsSequenceRepository.closeConnection(conn);
    }

    public void setDbGroupKeys(List<String> dbGroupKeys) {
        this.dbGroupKeys = dbGroupKeys;
    }

    public List<String> getDbGroupKeys() {
        return this.dbGroupKeys;
    }

    public void setDataSourceMap(Map<String, DataSource> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public Map<String, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setDataSourceCount(int dataSourceCount) {
        this.dataSourceCount = dataSourceCount;
    }

    public int getDataSourceCount() {
        return this.dataSourceCount;
    }

    public void setAdjust(boolean adjust) {
        this.adjust = adjust;
    }

    public boolean isAdjust() {
        return this.adjust;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setInnerStep(int innerStep) {
        this.innerStep = innerStep;
    }

    @Override
    public int getInnerStep() {
        return this.innerStep;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public String getNameColumnName() {
        return this.nameColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public void setGmtCreatedColumnName(String gmtCreatedColumnName) {
        this.gmtCreatedColumnName = gmtCreatedColumnName;
    }

    public String getGmtCreatedColumnName() {
        return this.gmtCreatedColumnName;
    }

    public void setGmtModifiedColumnName(String gmtModifiedColumnName) {
        this.gmtModifiedColumnName = gmtModifiedColumnName;
    }

    public String getGmtModifiedColumnName() {
        return this.gmtModifiedColumnName;
    }
}

