/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.spring.boot.autoconfigure;

import app.myoss.cloud.mybatis.mapper.register.MapperInterfaceRegister;
import app.myoss.cloud.mybatis.plugin.ParameterHandlerCustomizer;
import app.myoss.cloud.mybatis.plugin.ParameterHandlerInterceptor;
import app.myoss.cloud.mybatis.spring.boot.autoconfigure.ConfigurationCustomizer;
import app.myoss.cloud.mybatis.spring.boot.autoconfigure.MybatisProperties;
import app.myoss.cloud.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import app.myoss.cloud.mybatis.spring.mapper.ClassPathMapperScanner;
import app.myoss.cloud.mybatis.spring.mapper.MapperScannerConfigurer;
import app.myoss.cloud.mybatis.table.Sequence;
import app.myoss.cloud.mybatis.table.TableConfig;
import app.myoss.cloud.mybatis.table.TableMetaObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.mapper.MapperFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConditionalOnProperty(prefix="mybatis", value={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MybatisProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Configuration
public class MybatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MybatisAutoConfiguration.class);
    private final MybatisProperties properties;
    private final Interceptor[] interceptors;
    private final List<ConfigurationCustomizer> configurationCustomizers;
    private final ApplicationContext applicationContext;
    private final ResourceLoader resourceLoader;

    public MybatisAutoConfiguration(MybatisProperties properties, ObjectProvider<Interceptor[]> interceptorsProvider, ObjectProvider<List<ConfigurationCustomizer>> configurationCustomizersProvider, ApplicationContext applicationContext, ResourceLoader resourceLoader) {
        this.properties = properties;
        if (this.properties.getTableConfig() == null) {
            log.debug("MybatisProperties.tableConfig not config, initialize default");
            this.properties.setTableConfig(new TableConfig());
        }
        this.interceptors = (Interceptor[])interceptorsProvider.getIfAvailable();
        this.resourceLoader = resourceLoader;
        this.configurationCustomizers = (List)configurationCustomizersProvider.getIfAvailable();
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void checkConfigFileExists() {
        Map beanMap;
        if (this.properties.isCheckConfigLocation() && StringUtils.hasText((String)this.properties.getConfigLocation())) {
            Resource resource = this.resourceLoader.getResource(this.properties.getConfigLocation());
            Assert.state((boolean)resource.exists(), (String)("Cannot find config location: " + resource + " (please add config file or check your Mybatis configuration)"));
        }
        if (!CollectionUtils.isEmpty((Map)(beanMap = this.applicationContext.getBeansOfType(Sequence.class)))) {
            for (Map.Entry entry : beanMap.entrySet()) {
                TableMetaObject.addSequenceBean((String)entry.getKey(), (Sequence)entry.getValue());
            }
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        SqlSessionFactoryBean factory = MybatisAutoConfiguration.createSqlSessionFactoryBean(this.applicationContext, this.resourceLoader, dataSource, this.properties, this.configurationCustomizers, this.interceptors);
        return factory.getObject();
    }

    public static SqlSessionFactoryBean createSqlSessionFactoryBean(ApplicationContext applicationContext, ResourceLoader resourceLoader, DataSource dataSource, MybatisProperties properties, List<ConfigurationCustomizer> configurationCustomizers, Interceptor[] interceptors) {
        Object[] mapperLocations;
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        factory.setVfs(SpringBootVFS.class);
        if (StringUtils.hasText((String)properties.getConfigLocation())) {
            factory.setConfigLocation(resourceLoader.getResource(properties.getConfigLocation()));
        }
        MybatisAutoConfiguration.applyConfiguration(factory, properties, configurationCustomizers);
        if (properties.getConfigurationProperties() != null) {
            factory.setConfigurationProperties(properties.getConfigurationProperties());
        }
        MybatisAutoConfiguration.applyPlugins(applicationContext, factory, interceptors);
        Map databaseIdProviderMap = applicationContext.getBeansOfType(DatabaseIdProvider.class);
        if (!databaseIdProviderMap.isEmpty()) {
            DatabaseIdProvider databaseIdProvider = (DatabaseIdProvider)databaseIdProviderMap.values().iterator().next();
            factory.setDatabaseIdProvider(databaseIdProvider);
        }
        if (StringUtils.hasLength((String)properties.getTypeAliasesPackage())) {
            factory.setTypeAliasesPackage(properties.getTypeAliasesPackage());
        }
        if (StringUtils.hasLength((String)properties.getTypeHandlersPackage())) {
            factory.setTypeHandlersPackage(properties.getTypeHandlersPackage());
        }
        if (!ObjectUtils.isEmpty((Object[])(mapperLocations = properties.resolveMapperLocations()))) {
            factory.setMapperLocations((Resource[])mapperLocations);
        }
        return factory;
    }

    public static void applyPlugins(ApplicationContext applicationContext, SqlSessionFactoryBean factory, Interceptor[] interceptors) {
        Map beanMap = applicationContext.getBeansOfType(ParameterHandlerCustomizer.class);
        boolean emptyInterceptors = ObjectUtils.isEmpty((Object[])interceptors);
        if (CollectionUtils.isEmpty((Map)beanMap)) {
            if (!emptyInterceptors) {
                factory.setPlugins(interceptors);
            }
            return;
        }
        ParameterHandlerCustomizer parameterHandlerCustomizer = (ParameterHandlerCustomizer)beanMap.entrySet().iterator().next().getValue();
        if (emptyInterceptors) {
            ParameterHandlerInterceptor interceptor = new ParameterHandlerInterceptor(parameterHandlerCustomizer);
            factory.setPlugins(new Interceptor[]{interceptor});
            return;
        }
        if (Stream.of(interceptors).anyMatch(s -> s instanceof ParameterHandlerInterceptor)) {
            factory.setPlugins(interceptors);
        } else {
            ParameterHandlerInterceptor interceptor = new ParameterHandlerInterceptor(parameterHandlerCustomizer);
            Interceptor[] plugins = (Interceptor[])ArrayUtils.add((Object[])interceptors, (Object)interceptor);
            factory.setPlugins(plugins);
        }
    }

    public static void applyConfiguration(SqlSessionFactoryBean factory, MybatisProperties properties, List<ConfigurationCustomizer> configurationCustomizers) {
        org.apache.ibatis.session.Configuration configuration = properties.getConfiguration();
        if (configuration == null && !StringUtils.hasText((String)properties.getConfigLocation())) {
            configuration = new org.apache.ibatis.session.Configuration();
        }
        if (configuration != null && !CollectionUtils.isEmpty(configurationCustomizers)) {
            for (ConfigurationCustomizer customizer : configurationCustomizers) {
                customizer.customize(configuration);
            }
        }
        factory.setConfiguration(configuration);
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return MybatisAutoConfiguration.createSqlSessionTemplate(sqlSessionFactory, this.properties);
    }

    public static SqlSessionTemplate createSqlSessionTemplate(SqlSessionFactory sqlSessionFactory, MybatisProperties properties) {
        ExecutorType executorType = properties.getExecutorType();
        if (executorType != null) {
            return new SqlSessionTemplate(sqlSessionFactory, executorType);
        }
        return new SqlSessionTemplate(sqlSessionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public MapperInterfaceRegister mapperInterfaceRegister() {
        return new MapperInterfaceRegister(this.properties.getTableConfig());
    }

    @ConditionalOnExpression(value="#{'${mybatis.mapper-scanner.base-package:}'.length() > 0}")
    @Configuration
    public static class AutoConfiguredMapperScannerRegistrar2 {
        public AutoConfiguredMapperScannerRegistrar2() {
            log.debug("mybatis.mapper-scanner.base-package} is config [{}].", (Object)AutoConfiguredMapperScannerRegistrar2.class.getName());
        }

        @ConditionalOnMissingBean
        @Bean
        public MapperScannerConfigurer mapperScannerConfigurer(Environment environment) {
            Binder binder = Binder.get((Environment)environment);
            MybatisProperties.MapperScanner scanner = (MybatisProperties.MapperScanner)binder.bind("mybatis.mapper-scanner", MybatisProperties.MapperScanner.class).get();
            String basePackage = scanner.getBasePackage();
            Objects.requireNonNull(basePackage, "Property 'basePackage' is required");
            MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
            mapperScannerConfigurer.setBasePackage(basePackage);
            mapperScannerConfigurer.setSqlSessionFactoryBeanName(scanner.getSqlSessionFactoryName());
            mapperScannerConfigurer.setSqlSessionTemplateBeanName(scanner.getSqlSessionTemplateBeanName());
            if (scanner.getAnnotationClass() != null) {
                mapperScannerConfigurer.setAnnotationClass(scanner.getAnnotationClass());
            }
            if (scanner.getMarkerInterface() != null) {
                mapperScannerConfigurer.setMarkerInterface(scanner.getMarkerInterface());
            }
            return mapperScannerConfigurer;
        }
    }

    public static class AutoConfiguredMapperScannerRegistrar
    implements BeanFactoryAware,
    ImportBeanDefinitionRegistrar,
    ResourceLoaderAware {
        private BeanFactory beanFactory;
        private ResourceLoader resourceLoader;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            log.debug("Searching for mappers annotated with @Mapper");
            ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
            try {
                if (this.resourceLoader != null) {
                    scanner.setResourceLoader(this.resourceLoader);
                }
                List packages = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
                if (log.isDebugEnabled()) {
                    packages.forEach(pkg -> log.debug("Using auto-configuration base package '{}'", pkg));
                }
                scanner.setAnnotationClass(Mapper.class);
                scanner.registerFilters();
                scanner.doScan(StringUtils.toStringArray((Collection)packages));
            }
            catch (IllegalStateException ex) {
                log.debug("Could not determine auto-configuration package, automatic mapper scanning disabled.", (Throwable)ex);
            }
        }

        public void setBeanFactory(BeanFactory beanFactory) {
            this.beanFactory = beanFactory;
        }

        public void setResourceLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }
    }

    @ConditionalOnMissingBean(value={MapperFactoryBean.class})
    @Import(value={AutoConfiguredMapperScannerRegistrar.class})
    @Configuration
    public static class MapperScannerRegistrarNotFoundConfiguration {
        @PostConstruct
        public void afterPropertiesSet() {
            log.debug("No {} found.", (Object)MapperFactoryBean.class.getName());
        }
    }
}

