/*
 * Decompiled with CFR 0.152.
 */
package app.myoss.cloud.mybatis.generator.db.dialect;

import app.myoss.cloud.mybatis.generator.db.Column;
import app.myoss.cloud.mybatis.generator.db.Table;
import app.myoss.cloud.mybatis.generator.db.dialect.DatabaseDialects;
import java.util.Objects;

public interface DatabaseDialect {
    public String getDatabaseName();

    default public String getSelectInsertId() {
        DatabaseDialects databaseDialect = DatabaseDialects.getDatabaseDialect(this.getDatabaseName());
        Objects.requireNonNull(databaseDialect);
        return databaseDialect.getIdentityRetrievalStatement();
    }

    default public String getBeginningDelimiter() {
        return "";
    }

    default public String getEndingDelimiter() {
        return "";
    }

    default public String getEscapedColumnName(Table table, Column column) {
        if (column.isColumnNameDelimited()) {
            StringBuilder sb = new StringBuilder();
            if (table.getBeginningDelimiter() != null) {
                sb.append(table.getBeginningDelimiter());
            } else {
                sb.append(this.getBeginningDelimiter());
            }
            sb.append(column.getColumnName());
            if (table.getEndingDelimiter() != null) {
                sb.append(table.getEndingDelimiter());
            } else {
                sb.append(this.getEndingDelimiter());
            }
            return sb.toString();
        }
        return column.getColumnName();
    }
}

