/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.scala.spark.rapids;

import ai.rapids.cudf.CSVOptions;
import ai.rapids.cudf.ColumnVector;
import ai.rapids.cudf.DType;
import ai.rapids.cudf.HostMemoryBuffer;
import ai.rapids.cudf.ParquetOptions;
import ai.rapids.cudf.Scalar;
import ai.rapids.cudf.Schema;
import ai.rapids.cudf.Table;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.NoSuchElementException;
import ml.dmlc.xgboost4j.java.XGBoostSparkJNI;
import ml.dmlc.xgboost4j.java.spark.rapids.GpuColumnBatch;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuDataset;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuDataset$;
import ml.dmlc.xgboost4j.scala.spark.rapids.GpuDataset$$anonfun$ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildCsvOptions$2$;
import ml.dmlc.xgboost4j.scala.spark.rapids.RowConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.QueryExecutionException;
import org.apache.spark.sql.execution.QueryExecutionException$;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FilePartition$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.Platform;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.immutable.WrappedString;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class GpuDataset$ {
    public static final GpuDataset$ MODULE$;
    private final Log ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger;
    private final Map<String, Function2<CSVOptions.Builder, String, BoxedUnit>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$csvOptionParserMap;

    static {
        new GpuDataset$();
    }

    public Log ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger() {
        return this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger;
    }

    public <U> Function1<Iterator<GpuColumnBatch>, Iterator<U>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$getMapper(Function1<GpuColumnBatch, Iterator<U>> func, ClassTag<U> evidence$2) {
        return new Serializable(func){
            public static final long serialVersionUID = 0L;
            private final Function1 func$1;

            public final Iterator<U> apply(Iterator<GpuColumnBatch> batchIter) {
                Iterator iterator;
                if (batchIter.hasNext()) {
                    GpuColumnBatch batch = (GpuColumnBatch)batchIter.next();
                    if (batchIter.hasNext()) {
                        throw new UnsupportedOperationException("Column batch iterator returned multiple batches");
                    }
                    iterator = (Iterator)this.func$1.apply((Object)batch);
                } else {
                    iterator = package$.MODULE$.Iterator().empty();
                }
                return iterator;
            }
            {
                this.func$1 = func$1;
            }
        };
    }

    public Function1<GpuColumnBatch, Iterator<Object>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$maxDoubleMapper(int columnIndex) {
        return new Serializable(columnIndex){
            public static final long serialVersionUID = 0L;
            private final int columnIndex$1;

            public final Iterator<Object> apply(GpuColumnBatch b) {
                int gpuId = XGBoostSparkJNI.allocateGpuDevice();
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger().debug((Object)new StringBuilder().append((Object)"XGboost maxDoubleMapper get device: ").append((Object)BoxesRunTime.boxToInteger((int)gpuId)).toString());
                ColumnVector column = b.getColumnVector(this.columnIndex$1);
                Scalar scalar = column.max();
                return scalar.isValid() ? package$.MODULE$.Iterator().single((Object)BoxesRunTime.boxToDouble((double)scalar.getDouble())) : package$.MODULE$.Iterator().empty();
            }
            {
                this.columnIndex$1 = columnIndex$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Iterator<Row> columnBatchToRows(GpuColumnBatch batch) {
        void var3_3;
        TaskContext taskContext = TaskContext$.MODULE$.get();
        Iterator<Row> iter = new Iterator<Row>(batch){
            private final long numRows;
            private final StructType schema;
            private final RowConverter converter;
            private final int rowSize;
            private long buffer;
            private int nextRow;
            private final UnsafeRow row;
            public final GpuColumnBatch batch$1;

            public Iterator<Row> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<Row> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<Row> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<Row> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<Row, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<Row, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<Row> filter(Function1<Row, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Row, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<Row> withFilter(Function1<Row, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<Row> filterNot(Function1<Row, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<Row, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, Row, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<Row, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<Row> takeWhile(Function1<Row, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<Row>, Iterator<Row>> partition(Function1<Row, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<Row>, Iterator<Row>> span(Function1<Row, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<Row> dropWhile(Function1<Row, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<Row, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<Row, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<Row, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<Row, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<Row, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<Row> find(Function1<Row, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<Row, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<Row> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<Row>, Iterator<Row>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<Row> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<Row> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<Row> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<Row> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<Row, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<Row, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, Row, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<Row, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, Row, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<Row, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, Row, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<Row, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Row, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Row, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, Row, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<Row> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<Row> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<Row> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<Row> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<Row> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, Row, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Row, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            private long numRows() {
                return this.numRows;
            }

            private StructType schema() {
                return this.schema;
            }

            private RowConverter converter() {
                return this.converter;
            }

            private int rowSize() {
                return this.rowSize;
            }

            private long buffer() {
                return this.buffer;
            }

            private void buffer_$eq(long x$1) {
                this.buffer = x$1;
            }

            private int nextRow() {
                return this.nextRow;
            }

            private void nextRow_$eq(int x$1) {
                this.nextRow = x$1;
            }

            private UnsafeRow row() {
                return this.row;
            }

            public boolean hasNext() {
                return (long)this.nextRow() < this.numRows();
            }

            public Row next() {
                if ((long)this.nextRow() >= this.numRows()) {
                    throw new NoSuchElementException();
                }
                if (this.buffer() == 0L) {
                    this.initBuffer();
                }
                this.row().pointTo(null, this.buffer() + (long)(this.rowSize() * this.nextRow()), this.rowSize());
                this.nextRow_$eq(this.nextRow() + 1);
                return this.converter().toExternalRow((InternalRow)this.row());
            }

            public void close() {
                if (this.buffer() != 0L) {
                    Platform.freeMemory((long)this.buffer());
                    this.buffer_$eq(0L);
                }
            }

            private void initBuffer() {
                long[] nativeColumnPtrs = new long[this.batch$1.getNumColumns()];
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.batch$1.getNumColumns()).foreach$mVc$sp((Function1)new Serializable(this, nativeColumnPtrs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.1 $outer;
                    private final long[] nativeColumnPtrs$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.nativeColumnPtrs$1[i] = this.$outer.batch$1.getColumn(i);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nativeColumnPtrs$1 = nativeColumnPtrs$1;
                    }
                });
                this.buffer_$eq(XGBoostSparkJNI.buildUnsafeRows(nativeColumnPtrs));
            }
            {
                this.batch$1 = batch$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.numRows = batch$1.getNumRows();
                this.schema = batch$1.getSchema();
                this.converter = new RowConverter(this.schema());
                this.rowSize = UnsafeRow.calculateBitSetWidthInBytes((int)batch$1.getNumColumns()) + batch$1.getNumColumns() * 8;
                this.nextRow = 0;
                this.row = new UnsafeRow(this.schema().length());
            }
        };
        taskContext.addTaskCompletionListener((Function1)new Serializable((Iterator)iter){
            public static final long serialVersionUID = 0L;
            private final Iterator iter$1;

            public final void apply(TaskContext x$8) {
                ((AutoCloseable)this.iter$1).close();
            }
            {
                this.iter$1 = iter$1;
            }
        });
        return var3_3;
    }

    public StructType ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$numericAsFloats(StructType schema) {
        return new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final StructField apply(StructField x0$5) {
                StructField structField = x0$5;
                if (structField == null) return structField;
                String name = structField.name();
                DataType nt = structField.dataType();
                boolean nullable = structField.nullable();
                Metadata metadata = structField.metadata();
                if (!(nt instanceof NumericType)) return structField;
                return new StructField(name, (DataType)FloatType$.MODULE$, nullable, metadata);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
    }

    public Function2<Configuration, PartitionedFile, Table> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$getPartFileReader(SparkSession sparkSession, String sourceType, StructType schema, Map<String, String> options, boolean castAllToFloats) {
        block4: {
            Function2<Configuration, PartitionedFile, Table> function2;
            block3: {
                String string;
                block2: {
                    string = sourceType;
                    if (!"csv".equals(string)) break block2;
                    function2 = this.getCsvPartFileReader(sparkSession, schema, options, castAllToFloats);
                    break block3;
                }
                if (!"parquet".equals(string)) break block4;
                function2 = this.getParquetPartFileReader(sparkSession, schema, options, castAllToFloats);
            }
            return function2;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported source type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceType})));
    }

    private Function2<Configuration, PartitionedFile, Table> getCsvPartFileReader(SparkSession sparkSession, StructType inputSchema, Map<String, String> options, boolean castAllToFloats) {
        this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildCsvOptions(options);
        StructType schema = castAllToFloats ? this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$numericAsFloats(inputSchema) : inputSchema;
        return new Serializable(options, schema){
            public static final long serialVersionUID = 0L;
            private final Map options$1;
            private final StructType schema$2;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Table apply(Configuration conf, PartitionedFile partFile) {
                Table table;
                Tuple2 tuple22;
                Tuple2<HostMemoryBuffer, Object> tuple2 = GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$readPartFileFully(conf, partFile);
                if (tuple2 == null) throw new MatchError(tuple2);
                HostMemoryBuffer dataBuffer = (HostMemoryBuffer)tuple2._1();
                long dataSize = tuple2._2$mcJ$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataBuffer, (Object)BoxesRunTime.boxToLong((long)dataSize));
                HostMemoryBuffer dataBuffer2 = (HostMemoryBuffer)tuple23._1();
                long dataSize2 = tuple23._2$mcJ$sp();
                try {
                    Schema.Builder csvSchemaBuilder = Schema.builder();
                    this.schema$2.foreach((Function1)new Serializable(this, csvSchemaBuilder){
                        public static final long serialVersionUID = 0L;
                        private final Schema.Builder csvSchemaBuilder$1;

                        public final Schema.Builder apply(StructField f) {
                            return this.csvSchemaBuilder$1.column(GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$toDType(f.dataType()), f.name());
                        }
                        {
                            this.csvSchemaBuilder$1 = csvSchemaBuilder$1;
                        }
                    });
                    Table table2 = Table.readCSV((Schema)csvSchemaBuilder.build(), (CSVOptions)GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildCsvOptions((Map<String, String>)this.options$1), (HostMemoryBuffer)dataBuffer2, (long)dataSize2);
                    int numColumns = table2.getNumberOfColumns();
                    if (this.schema$2.length() != numColumns) {
                        table2.close();
                        throw new QueryExecutionException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.schema$2.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but only read ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)table2.getNumberOfColumns()), partFile}))).toString(), QueryExecutionException$.MODULE$.$lessinit$greater$default$2());
                    }
                    table = table2;
                }
                catch (Throwable throwable) {
                    void var9_8;
                    var9_8.close();
                    throw throwable;
                }
                dataBuffer2.close();
                return table;
            }
            {
                this.options$1 = options$1;
                this.schema$2 = schema$2;
            }
        };
    }

    private Function2<Configuration, PartitionedFile, Table> getParquetPartFileReader(SparkSession sparkSession, StructType schema, Map<String, String> options, boolean castToFloat) {
        this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildParquetOptions(options, schema);
        return new Serializable(schema, options, castToFloat){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            private final Map options$2;
            private final boolean castToFloat$1;

            /*
             * Loose catch block
             * WARNING - void declaration
             */
            public final Table apply(Configuration conf, PartitionedFile partFile) {
                Tuple2<HostMemoryBuffer, Object> tuple2 = GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$readPartFileFully(conf, partFile);
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    HostMemoryBuffer dataBuffer = (HostMemoryBuffer)tuple2._1();
                    long dataSize = tuple2._2$mcJ$sp();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)dataBuffer, (Object)BoxesRunTime.boxToLong((long)dataSize));
                    HostMemoryBuffer dataBuffer2 = (HostMemoryBuffer)tuple23._1();
                    long dataSize2 = tuple23._2$mcJ$sp();
                    ParquetOptions parquetOptions = GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildParquetOptions((Map<String, String>)this.options$2, this.schema$1);
                    ObjectRef table = ObjectRef.create((Object)Table.readParquet((ParquetOptions)parquetOptions, (HostMemoryBuffer)dataBuffer2, (long)dataSize2));
                    int numColumns = ((Table)table.elem).getNumberOfColumns();
                    if (this.schema$1.length() > numColumns) {
                        ((Table)table.elem).close();
                        throw new QueryExecutionException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", " columns "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.schema$1.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but only read ", " from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numColumns), partFile}))).toString(), QueryExecutionException$.MODULE$.$lessinit$greater$default$2());
                    }
                    if (this.castToFloat$1) {
                        ColumnVector[] columns = new ColumnVector[numColumns];
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numColumns).foreach$mVc$sp((Function1)new Serializable(this, table, columns){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.getParquetPartFileReader.1 $outer;
                            private final ObjectRef table$1;
                            private final ColumnVector[] columns$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                ColumnVector c = ((Table)this.table$1.elem).getColumn(i);
                                DataType dataType = this.$outer.schema$1.fields()[i].dataType();
                                ColumnVector columnVector = dataType instanceof NumericType ? c.asFloats() : c.incRefCount();
                                this.columns$1[i] = columnVector;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.table$1 = table$1;
                                this.columns$1 = columns$1;
                            }
                        });
                        Table tmp = (Table)table.elem;
                        table.elem = new Table(columns);
                        tmp.close();
                        Predef$.MODULE$.refArrayOps((Object[])columns).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ColumnVector v) {
                                if (v != null) {
                                    v.close();
                                }
                            }
                        });
                    }
                    Table table2 = (Table)table.elem;
                    dataBuffer2.close();
                    return table2;
                }
                throw new MatchError(tuple2);
                {
                    catch (Throwable throwable) {
                        try {
                            void var16_13;
                            Predef$.MODULE$.refArrayOps((Object[])var16_13).foreach((Function1)new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            void var9_8;
                            var9_8.close();
                            throw throwable2;
                        }
                    }
                }
            }
            {
                this.schema$1 = schema$1;
                this.options$2 = options$2;
                this.castToFloat$1 = castToFloat$1;
            }
        };
    }

    public CSVOptions ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildCsvOptions(Map<String, String> options) {
        CSVOptions.Builder builder = CSVOptions.builder();
        options.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                Tuple2<String, String> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(builder){
            public static final long serialVersionUID = 0L;
            private final CSVOptions.Builder builder$1;

            public final void apply(Tuple2<String, String> x$13) {
                Tuple2<String, String> tuple2 = x$13;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Function2 parseFunc = (Function2)GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$csvOptionParserMap().getOrElse((Object)k, (Function0)new Serializable(this, k){
                        public static final long serialVersionUID = 0L;
                        public final String k$1;

                        public final Function2<CSVOptions.Builder, String, Nothing$> apply() {
                            return new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildCsvOptions$2$$anonfun$11 $outer;

                                public final Nothing$ apply(CSVOptions.Builder x$11, String x$12) {
                                    throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV option ", " not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.k$1})));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            };
                        }
                        {
                            this.k$1 = k$1;
                        }
                    });
                    BoxedUnit boxedUnit = (BoxedUnit)parseFunc.apply((Object)this.builder$1, (Object)v);
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    public ParquetOptions ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$buildParquetOptions(Map<String, String> options, StructType schema) {
        if (options.nonEmpty()) {
            throw new UnsupportedOperationException("No Parquet read options are supported");
        }
        ParquetOptions.Builder builder = ParquetOptions.builder();
        builder.includeColumn((String[])((TraversableOnce)schema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$14) {
                return x$14.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)));
        return builder.build();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<HostMemoryBuffer, Object> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$readPartFileFully(Configuration conf, PartitionedFile partFile) {
        Path rawPath = new Path(partFile.filePath());
        FileSystem fs = rawPath.getFileSystem(conf);
        Path path = fs.makeQualified(rawPath);
        long fileSize = fs.getFileStatus(path).getLen();
        boolean succeeded = false;
        HostMemoryBuffer hmb = HostMemoryBuffer.allocate((long)fileSize);
        long totalBytesRead = 0L;
        byte[] buffer = new byte[16384];
        CompressionCodecFactory codecFactory = new CompressionCodecFactory(conf);
        CompressionCodec codec = codecFactory.getCodec(path);
        FSDataInputStream rawInput = fs.open(path);
        FSDataInputStream in = codec == null ? rawInput : codec.createInputStream((InputStream)rawInput);
        try {
            int numBytes = in.read(buffer);
            while (numBytes >= 0) {
                if (totalBytesRead + (long)numBytes > hmb.getLength()) {
                    hmb = this.growHostBuffer(hmb, totalBytesRead + (long)numBytes);
                }
                hmb.setBytes(totalBytesRead, buffer, 0L, (long)numBytes);
                totalBytesRead += (long)numBytes;
                numBytes = in.read(buffer);
            }
        }
        catch (Throwable throwable) {
            try {
                void var17_14;
                var17_14.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                void var9_8;
                void var8_7;
                if (var8_7 != false) throw throwable2;
                var9_8.close();
                throw throwable2;
            }
        }
        in.close();
        return new Tuple2((Object)hmb, (Object)BoxesRunTime.boxToLong((long)totalBytesRead));
    }

    /*
     * WARNING - void declaration
     */
    private HostMemoryBuffer growHostBuffer(HostMemoryBuffer original, long needed) {
        long newSize = Math.max(original.getLength() * 2L, needed);
        HostMemoryBuffer result = HostMemoryBuffer.allocate((long)newSize);
        try {
            result.copyFromHostBuffer(0L, original, 0L, original.getLength());
            original.close();
            return result;
        }
        catch (Throwable throwable) {
            void var6_4;
            var6_4.close();
            throw throwable;
        }
    }

    public DType ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$toDType(DataType dataType) {
        DataType dataType2;
        block10: {
            DType dType;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            dataType2 = dataType;
                                            boolean bl = BooleanType$.MODULE$.equals(dataType2) ? true : ByteType$.MODULE$.equals(dataType2);
                                            if (!bl) break block2;
                                            dType = DType.INT8;
                                            break block3;
                                        }
                                        if (!ShortType$.MODULE$.equals(dataType2)) break block4;
                                        dType = DType.INT16;
                                        break block3;
                                    }
                                    if (!IntegerType$.MODULE$.equals(dataType2)) break block5;
                                    dType = DType.INT32;
                                    break block3;
                                }
                                if (!LongType$.MODULE$.equals(dataType2)) break block6;
                                dType = DType.INT64;
                                break block3;
                            }
                            if (!FloatType$.MODULE$.equals(dataType2)) break block7;
                            dType = DType.FLOAT32;
                            break block3;
                        }
                        if (!DoubleType$.MODULE$.equals(dataType2)) break block8;
                        dType = DType.FLOAT64;
                        break block3;
                    }
                    if (!DateType$.MODULE$.equals(dataType2)) break block9;
                    dType = DType.DATE32;
                    break block3;
                }
                if (!TimestampType$.MODULE$.equals(dataType2)) break block10;
                dType = DType.TIMESTAMP;
            }
            return dType;
        }
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Spark SQL type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType2})));
    }

    private char toChar(String str) throws IllegalArgumentException {
        char c;
        WrappedString wrappedString;
        block15: {
            int n;
            block7: {
                block14: {
                    Some some;
                    block13: {
                        Some some2;
                        block12: {
                            Some some3;
                            block11: {
                                Some some4;
                                block10: {
                                    Some some5;
                                    block9: {
                                        Some some6;
                                        block8: {
                                            block6: {
                                                int c2;
                                                char c3;
                                                wrappedString = Predef$.MODULE$.wrapString(str);
                                                Some some7 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some7.isEmpty() && some7.get() != null && ((SeqLike)some7.get()).lengthCompare(0) == 0) {
                                                    throw new IllegalArgumentException("Delimiter cannot be empty string");
                                                }
                                                Some some8 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (!some8.isEmpty() && some8.get() != null && ((SeqLike)some8.get()).lengthCompare(1) == 0 && '\\' == (c3 = BoxesRunTime.unboxToChar((Object)((SeqLike)some8.get()).apply(0)))) {
                                                    throw new IllegalArgumentException("Single backslash is prohibited. It has special meaning as beginning of an escape sequence. To get the backslash character, pass a string with two backslashes as the delimiter.");
                                                }
                                                Some some9 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                                if (some9.isEmpty() || some9.get() == null || ((SeqLike)some9.get()).lengthCompare(1) != 0) break block6;
                                                n = c2 = BoxesRunTime.unboxToChar((Object)((SeqLike)some9.get()).apply(0));
                                                break block7;
                                            }
                                            Some some10 = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
                                            if (some10.isEmpty() || some10.get() == null || ((SeqLike)some10.get()).lengthCompare(2) != 0) break block8;
                                            char c4 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(0));
                                            char c5 = BoxesRunTime.unboxToChar((Object)((SeqLike)some10.get()).apply(1));
                                            if ('\\' != c4 || 't' != c5) break block8;
                                            n = 9;
                                            break block7;
                                        }
                                        if ((some6 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some6.get() == null || ((SeqLike)some6.get()).lengthCompare(2) != 0) break block9;
                                        char c6 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(0));
                                        char c7 = BoxesRunTime.unboxToChar((Object)((SeqLike)some6.get()).apply(1));
                                        if ('\\' != c6 || 'r' != c7) break block9;
                                        n = 13;
                                        break block7;
                                    }
                                    if ((some5 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some5.get() == null || ((SeqLike)some5.get()).lengthCompare(2) != 0) break block10;
                                    char c8 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(0));
                                    char c9 = BoxesRunTime.unboxToChar((Object)((SeqLike)some5.get()).apply(1));
                                    if ('\\' != c8 || 'b' != c9) break block10;
                                    n = 8;
                                    break block7;
                                }
                                if ((some4 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some4.get() == null || ((SeqLike)some4.get()).lengthCompare(2) != 0) break block11;
                                char c10 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(0));
                                char c11 = BoxesRunTime.unboxToChar((Object)((SeqLike)some4.get()).apply(1));
                                if ('\\' != c10 || 'f' != c11) break block11;
                                n = 12;
                                break block7;
                            }
                            if ((some3 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some3.get() == null || ((SeqLike)some3.get()).lengthCompare(2) != 0) break block12;
                            char c12 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(0));
                            char c13 = BoxesRunTime.unboxToChar((Object)((SeqLike)some3.get()).apply(1));
                            if ('\\' != c12 || '\"' != c13) break block12;
                            n = 34;
                            break block7;
                        }
                        if ((some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(2) != 0) break block13;
                        char c14 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(0));
                        char c15 = BoxesRunTime.unboxToChar((Object)((SeqLike)some2.get()).apply(1));
                        if ('\\' != c14 || '\'' != c15) break block13;
                        n = 39;
                        break block7;
                    }
                    if ((some = Seq$.MODULE$.unapplySeq((Seq)wrappedString)).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block14;
                    char c16 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0));
                    char c17 = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(1));
                    if ('\\' != c16 || '\\' != c17) break block14;
                    n = 92;
                    break block7;
                }
                String string = str;
                String string2 = "\u0000";
                if (string != null ? !string.equals(string2) : string2 != null) break block15;
                n = 0;
            }
            return (char)n;
        }
        Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedString);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0 && '\\' == (c = BoxesRunTime.unboxToChar((Object)((SeqLike)some.get()).apply(0)))) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported special character for delimiter: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delimiter cannot be more than one character: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{str})));
    }

    private boolean getBool(String paramName, String paramVal) {
        block4: {
            boolean bl;
            block3: {
                String lowerParamVal;
                block2: {
                    String string = lowerParamVal = paramVal.toLowerCase(Locale.ROOT);
                    String string2 = "true";
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    bl = true;
                    break block3;
                }
                String string = lowerParamVal;
                String string3 = "false";
                if (string != null ? !string.equals(string3) : string3 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new Exception(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " flag can be true or false"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paramName})));
    }

    public void ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVCommentOption(CSVOptions.Builder b, String v) {
        b.withComment(this.toChar(v));
    }

    public void ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVHeaderOption(CSVOptions.Builder b, String v) {
        if (this.getBool("header", v)) {
            b.hasHeader();
        }
    }

    public void ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVNullValueOption(CSVOptions.Builder b, String v) {
        b.withNullValue(new String[]{v});
    }

    public void ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVQuoteOption(CSVOptions.Builder b, String v) {
        b.withQuote(this.toChar(v));
    }

    public void ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVSepOption(CSVOptions.Builder b, String v) {
        b.withDelim(this.toChar(v));
    }

    public Map<String, Function2<CSVOptions.Builder, String, BoxedUnit>> ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$csvOptionParserMap() {
        return this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$csvOptionParserMap;
    }

    public FilePartition ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$createFilePartition(int size, Seq<PartitionedFile> files) {
        FilePartition filePartition;
        try {
            filePartition = new FilePartition(size, files);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger().debug((Object)"FilePartition, normal Apache Spark version failed");
            Method fpClass = FilePartition$.MODULE$.getClass().getMethod("apply", Integer.TYPE, Seq.class, Seq.class);
            filePartition = (FilePartition)fpClass.invoke((Object)FilePartition$.MODULE$, new Integer(size), files, Seq$.MODULE$.empty());
        }
        return filePartition;
    }

    public Option<Seq<FilePartition>> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    private GpuDataset$() {
        MODULE$ = this;
        this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$logger = LogFactory.getLog(GpuDataset.class);
        this.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$csvOptionParserMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CSVOptions.Builder b, String v) {
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVCommentOption(b, v);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CSVOptions.Builder b, String v) {
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVHeaderOption(b, v);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nullValue"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CSVOptions.Builder b, String v) {
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVNullValueOption(b, v);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quote"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CSVOptions.Builder b, String v) {
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVQuoteOption(b, v);
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sep"), (Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(CSVOptions.Builder b, String v) {
                GpuDataset$.MODULE$.ml$dmlc$xgboost4j$scala$spark$rapids$GpuDataset$$parseCSVSepOption(b, v);
            }
        })}));
    }
}

