/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import water.DKV;
import water.Key;
import water.TestUtil;
import water.udf.CBlock;
import water.udf.CFunc2;
import water.udf.CFuncRef;
import water.udf.DkvClassLoader;
import water.udf.JFuncTest;
import water.udf.JFuncUtils;
import water.udf.JythonCFuncLoader;
import water.util.ArrayUtils;

public class JythonCFuncTest
extends TestUtil {
    @BeforeClass
    public static void setup() {
        JythonCFuncTest.stall_till_cloudsize((int)1);
    }

    @Test
    public void testPyFunc2InvocationFromResources() throws Exception {
        String[] functionResources = JythonCFuncTest.ar((String[])new String[]{"py/test_cfunc2.py", "py/__init__.py"});
        CFuncRef cFuncRef = JFuncUtils.loadTestFunc((String)"python", (String)"test1.py", (String[])functionResources, (String)"py.test_cfunc2.TestCFunc2");
        this.testPyFunc2Invocation(cFuncRef, functionResources);
    }

    @Test
    public void testPyFunc2InvocationFromString() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try (InputStream is = cl.getResourceAsStream("py/test_cfunc2.py");){
            byte[] ba = IOUtils.toByteArray((InputStream)is);
            CFuncRef cFuncRef = JFuncUtils.loadRawTestFunc((String)"python", (String)"test2.py", (String)"test.TestCFunc2", (byte[])ba, (String)"test.py");
            this.testPyFunc2Invocation(cFuncRef, new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPyFunc2Invocation(CFuncRef testFuncDef, String[] resourcesToSkip) throws Exception {
        try {
            ClassLoader skippingCl = JFuncUtils.getSkippingClassloader((ClassLoader)JythonCFuncTest.class.getClassLoader(), (String[])new String[0], (String[])resourcesToSkip);
            DkvClassLoader cl = new DkvClassLoader(testFuncDef, skippingCl);
            JythonCFuncLoader loader = new JythonCFuncLoader();
            CFunc2 testFunc = (CFunc2)loader.load(testFuncDef.funcName, CFunc2.class, (ClassLoader)cl);
            CBlock.CRow crow1 = JFuncTest.mockedRow((int)10, (double)1.0);
            CBlock.CRow crow2 = JFuncTest.mockedRow((int)5, (double)1.0);
            Assert.assertEquals((String)"Test testFunc call should return expected value", (double)(ArrayUtils.sum((double[])crow1.readDoubles()) + ArrayUtils.sum((double[])crow2.readDoubles())), (double)testFunc.apply(crow1, crow2), (double)1.0E-10);
        }
        finally {
            DKV.remove((Key)testFuncDef.getKey());
        }
    }
}

