/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.GraknTxType;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.graph.internal.VertexElement;
import ai.grakn.util.Schema;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraknTitanGraph
extends AbstractGraknGraph<TitanGraph> {
    public GraknTitanGraph(TitanGraph graph, String name, String engineUrl, Properties properties) {
        super((Graph)graph, name, engineUrl, properties);
    }

    public boolean isConceptModified(ConceptImpl concept) {
        TitanVertex vertex = (TitanVertex)concept.vertex().element();
        return vertex.isModified() || vertex.isNew();
    }

    public void openTransaction(GraknTxType txType) {
        super.openTransaction(txType);
        if (((TitanGraph)this.getTinkerPopGraph()).isOpen() && !((TitanGraph)this.getTinkerPopGraph()).tx().isOpen()) {
            ((TitanGraph)this.getTinkerPopGraph()).tx().open();
        }
    }

    public boolean isSessionClosed() {
        return ((TitanGraph)this.getTinkerPopGraph()).isClosed();
    }

    public int numOpenTx() {
        return ((StandardTitanGraph)this.getTinkerPopGraph()).getOpenTxs();
    }

    protected void clearGraph() {
        TitanCleanup.clear((TitanGraph)((TitanGraph)this.getTinkerPopGraph()));
    }

    public void commitTransactionInternal() {
        this.executeLockingMethod(() -> {
            super.commitTransactionInternal();
            return null;
        });
    }

    VertexElement addVertex(Schema.BaseType baseType) {
        return this.executeLockingMethod(() -> super.addVertex(baseType));
    }

    private <X> X executeLockingMethod(Supplier<X> method) {
        try {
            return method.get();
        }
        catch (TitanException e) {
            if (e.isCausedBy(TemporaryLockingException.class) || e.isCausedBy(PermanentLockingException.class)) {
                throw TemporaryWriteException.temporaryLock((Exception)((Object)e));
            }
            throw GraknBackendException.unknown((Exception)((Object)e));
        }
    }

    public void validVertex(Vertex vertex) {
        super.validVertex(vertex);
        if (((TitanVertex)vertex).isRemoved()) {
            throw new IllegalStateException("The vertex [" + vertex + "] has been removed and is no longer valid");
        }
    }
}

