/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.tinkerpop.optimize.TitanTraversalUtil;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Scoping;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.FlatMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

class TitanPreviousPropertyStep<S>
extends FlatMapStep<S, TitanVertex>
implements Scoping {
    private static final long serialVersionUID = -8906462828437711078L;
    private final String propertyKey;
    private final String stepLabel;

    TitanPreviousPropertyStep(Traversal.Admin traversal, String propertyKey, String stepLabel) {
        super(traversal);
        this.propertyKey = Objects.requireNonNull(propertyKey);
        this.stepLabel = Objects.requireNonNull(stepLabel);
    }

    protected Iterator<TitanVertex> flatMap(Traverser.Admin<S> traverser) {
        TitanTransaction tx = TitanTraversalUtil.getTx((Traversal.Admin)this.traversal);
        Object value = this.getNullableScopeValue(Pop.first, this.stepLabel, traverser);
        return value != null ? this.verticesWithProperty(tx, value) : Collections.emptyIterator();
    }

    private Iterator<TitanVertex> verticesWithProperty(TitanTransaction tx, Object value) {
        return tx.query().has(this.propertyKey, value).vertices().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TitanPreviousPropertyStep that = (TitanPreviousPropertyStep)((Object)o);
        return this.propertyKey.equals(that.propertyKey) && this.stepLabel.equals(that.stepLabel);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.propertyKey.hashCode();
        result = 31 * result + this.stepLabel.hashCode();
        return result;
    }

    public String toString() {
        return StringFactory.stepString((Step)this, (Object[])new Object[]{this.propertyKey, this.stepLabel});
    }

    public Set<String> getScopeKeys() {
        return Collections.singleton(this.stepLabel);
    }

    public Set<TraverserRequirement> getRequirements() {
        return EnumSet.of(TraverserRequirement.LABELED_PATH);
    }
}

