/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraphRuntimeException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import ai.grakn.util.ErrorMessage;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraknTitanGraph
extends AbstractGraknGraph<TitanGraph> {
    public GraknTitanGraph(TitanGraph graph, String name, String engineUrl, boolean batchLoading) {
        super((Graph)graph, name, engineUrl, batchLoading);
    }

    public boolean isConceptModified(ConceptImpl concept) {
        TitanVertex vertex = (TitanVertex)concept.getVertex();
        return vertex.isModified() || vertex.isNew();
    }

    protected void clearGraph() {
        TitanGraph titanGraph = this.getTinkerPopGraph();
        titanGraph.close();
        TitanCleanup.clear((TitanGraph)titanGraph);
    }

    public void closeGraph(String reason) {
        this.finaliseClose(this::closeTitan, reason);
    }

    public TitanGraph getTinkerPopGraph() {
        TitanGraph graph = (TitanGraph)super.getTinkerPopGraph();
        if (graph.isClosed()) {
            throw new GraphRuntimeException(ErrorMessage.GRAPH_PERMANENTLY_CLOSED.getMessage(new Object[]{this.getKeyspace()}));
        }
        return graph;
    }

    public void commitTransaction() {
        try {
            super.commitTransaction();
        }
        catch (TitanException e) {
            throw new GraknBackendException((Exception)((Object)e));
        }
        if (!this.getTinkerPopGraph().tx().isOpen()) {
            this.getTinkerPopGraph().tx().open();
        }
    }

    public boolean validVertex(Vertex vertex) {
        return !((TitanVertex)vertex).isRemoved() && super.validVertex(vertex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTitan() {
        StandardTitanGraph graph;
        StandardTitanGraph standardTitanGraph = graph = (StandardTitanGraph)this.getTinkerPopGraph();
        synchronized (standardTitanGraph) {
            if (graph.tx().isOpen()) {
                graph.tx().close();
            }
            if (graph.getOpenTxs() == 0) {
                this.closePermanent();
            }
        }
    }
}

