/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.factory.AbstractInternalFactory;
import ai.grakn.graph.internal.GraknTitanGraph;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class TitanInternalFactory
extends AbstractInternalFactory<GraknTitanGraph, TitanGraph> {
    private static final String DEFAULT_CONFIG = "backend-default";

    TitanInternalFactory(String keyspace, String engineUrl, Properties properties) {
        super(keyspace, engineUrl, properties);
    }

    boolean isClosed(TitanGraph innerGraph) {
        return innerGraph.isClosed();
    }

    public TitanGraph getGraphWithNewTransaction(TitanGraph graph) {
        if (!graph.tx().isOpen()) {
            graph.tx().open();
        }
        return graph;
    }

    GraknTitanGraph buildGraknGraphFromTinker(TitanGraph graph, boolean batchLoading) {
        return new GraknTitanGraph(graph, this.keyspace, this.engineUrl, batchLoading);
    }

    TitanGraph buildTinkerPopGraph(boolean batchLoading) {
        return this.newTitanGraph(this.keyspace, this.engineUrl, this.properties, batchLoading);
    }

    private synchronized TitanGraph newTitanGraph(String name, String address, Properties properties, boolean batchLoading) {
        TitanGraph titanGraph = this.configureGraph(name, address, properties, batchLoading);
        TitanInternalFactory.buildTitanIndexes(titanGraph);
        titanGraph.tx().onClose((Consumer)Transaction.CLOSE_BEHAVIOR.ROLLBACK);
        return titanGraph;
    }

    private TitanGraph configureGraph(String name, String address, Properties properties, boolean batchLoading) {
        if (properties == null) {
            properties = new Properties();
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(DEFAULT_CONFIG);
            try {
                properties.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(ErrorMessage.INVALID_PATH_TO_CONFIG.getMessage(new Object[]{DEFAULT_CONFIG}), e);
            }
        }
        TitanFactory.Builder builder = TitanFactory.build().set("storage.hostname", (Object)address).set("storage.cassandra.keyspace", (Object)name).set("storage.batch-loading", (Object)batchLoading);
        properties.entrySet().forEach(entry -> builder.set(entry.getKey().toString(), entry.getValue()));
        return builder.open();
    }

    private static void buildTitanIndexes(TitanGraph graph) {
        TitanManagement management = graph.openManagement();
        TitanInternalFactory.makeVertexLabels(management);
        TitanInternalFactory.makeEdgeLabels(management);
        TitanInternalFactory.makePropertyKeys(management);
        TitanInternalFactory.makeIndicesVertexCentric(management);
        TitanInternalFactory.makeIndicesComposite(management);
        management.commit();
    }

    private static void makeEdgeLabels(TitanManagement management) {
        for (Schema.EdgeLabel edgeLabel : Schema.EdgeLabel.values()) {
            EdgeLabel label = management.getEdgeLabel(edgeLabel.getLabel());
            if (label != null) continue;
            management.makeEdgeLabel(edgeLabel.getLabel()).make();
        }
    }

    private static void makeVertexLabels(TitanManagement management) {
        for (Schema.BaseType baseType : Schema.BaseType.values()) {
            VertexLabel foundLabel = management.getVertexLabel(baseType.name());
            if (foundLabel != null) continue;
            management.makeVertexLabel(baseType.name()).make();
        }
    }

    private static void makeIndicesVertexCentric(TitanManagement management) {
        ResourceBundle keys = ResourceBundle.getBundle("indices-edges");
        Set<String> edgeLabels = keys.keySet();
        for (String edgeLabel : edgeLabels) {
            String[] propertyKey;
            String properties = keys.getString(edgeLabel);
            if (properties.length() <= 0) continue;
            for (String aPropertyKey : propertyKey = keys.getString(edgeLabel).split(",")) {
                PropertyKey key = management.getPropertyKey(aPropertyKey);
                if (key == null) {
                    throw new RuntimeException("Trying to create edge index on label [" + edgeLabel + "] but the property [" + aPropertyKey + "] does not exist");
                }
                RelationType relationType = management.getRelationType(edgeLabel);
                if (management.getRelationIndex(relationType, edgeLabel + "by" + aPropertyKey) != null) continue;
                EdgeLabel label = management.getEdgeLabel(edgeLabel);
                management.buildEdgeIndex(label, edgeLabel + "by" + aPropertyKey, Direction.OUT, Order.decr, new PropertyKey[]{key});
            }
        }
    }

    private static void makePropertyKeys(TitanManagement management) {
        Arrays.stream(Schema.ConceptProperty.values()).forEach(property -> TitanInternalFactory.makePropertyKey(management, property.name(), property.getDataType()));
        Arrays.stream(Schema.EdgeProperty.values()).forEach(property -> TitanInternalFactory.makePropertyKey(management, property.name(), property.getDataType()));
    }

    private static void makePropertyKey(TitanManagement management, String propertyKey, Class type) {
        if (management.getPropertyKey(propertyKey) == null) {
            management.makePropertyKey(propertyKey).dataType(type).make();
        }
    }

    private static void makeIndicesComposite(TitanManagement management) {
        ResourceBundle keys = ResourceBundle.getBundle("indices-composite");
        Set<String> keyString = keys.keySet();
        for (String propertyKeyLabel : keyString) {
            String indexLabel = "by" + propertyKeyLabel;
            TitanGraphIndex index = management.getGraphIndex(indexLabel);
            if (index != null) continue;
            boolean isUnique = Boolean.parseBoolean(keys.getString(propertyKeyLabel));
            PropertyKey key = management.getPropertyKey(propertyKeyLabel);
            TitanManagement.IndexBuilder indexBuilder = management.buildIndex(indexLabel, Vertex.class).addKey(key);
            if (isUnique) {
                indexBuilder.unique();
            }
            indexBuilder.buildCompositeIndex();
        }
    }
}

