/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Grakn;
import ai.grakn.Keyspace;
import ai.grakn.util.SimpleURI;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MigrationOptions {
    public static final String MAX_DELAY_DEFAULT_VALUE = "1000";
    public static final String RETRY_DEFAULT_VALUE = "5";
    public static final String LINES_DEFAULT_VALUE = "-1";
    private int numberOptions;
    protected final Options options = new Options();
    protected CommandLine command;

    public MigrationOptions() {
        this.options.addOption("v", "verbose", false, "Print counts of migrated data.");
        this.options.addOption("h", "help", false, "Print usage message.");
        this.options.addOption("k", "keyspace", true, "Grakn graph. Required.");
        this.options.addOption("u", "uri", true, "Location of Grakn Engine.");
        this.options.addOption("m", "maxdelay", true, "Max delay before a request is batched.");
        this.options.addOption("n", "no", false, "Write to standard out.");
        this.options.addOption("c", "config", true, "Configuration file.");
        this.options.addOption("r", "retry", true, "Number of times to retry sending tasks if engine is not available");
        this.options.addOption("d", "debug", false, "Immediately stop and fail migration if an error occurs");
        this.options.addOption("z", "lines", true, "Number of lines to be processed. Used for testing when we want to stop earlier.");
    }

    public boolean isVerbose() {
        return this.command.hasOption("v");
    }

    public boolean isHelp() {
        return this.command.hasOption("h");
    }

    public boolean isNo() {
        return this.command.hasOption("n");
    }

    public boolean isDebug() {
        return this.command.hasOption("d");
    }

    public Keyspace getKeyspace() {
        if (!this.command.hasOption("k")) {
            throw new IllegalArgumentException("Keyspace missing (-k)");
        }
        return Keyspace.of((String)this.command.getOptionValue("k"));
    }

    @Nullable
    public String getConfiguration() {
        return this.command.hasOption("c") ? this.command.getOptionValue("c") : null;
    }

    public SimpleURI getUri() {
        return this.command.hasOption("u") ? new SimpleURI(this.command.getOptionValue("u")) : Grakn.DEFAULT_URI;
    }

    public Options getOptions() {
        return this.options;
    }

    public int getNumberOptions() {
        return this.numberOptions;
    }

    public String getInput() {
        if (!this.command.hasOption("i")) {
            throw new IllegalArgumentException("Data file missing (-i)");
        }
        return this.resolvePath(this.command.getOptionValue("i"));
    }

    public boolean hasInput() {
        return this.command.hasOption("i");
    }

    public String getTemplate() {
        if (!this.command.hasOption("t")) {
            throw new IllegalArgumentException("Template file missing (-t)");
        }
        return this.resolvePath(this.command.getOptionValue("t"));
    }

    public int getRetry() {
        return Integer.parseInt(this.command.getOptionValue("r", RETRY_DEFAULT_VALUE));
    }

    public int getMaxDelay() {
        return Integer.parseInt(this.command.getOptionValue("m", MAX_DELAY_DEFAULT_VALUE));
    }

    public int getLines() {
        return Integer.parseInt(this.command.getOptionValue("z", LINES_DEFAULT_VALUE));
    }

    protected void parse(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            this.command = parser.parse(this.options, args);
            this.numberOptions = this.command.getOptions().length;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String resolvePath(String path) {
        Path givenPath = Paths.get(path, new String[0]);
        if (givenPath.isAbsolute()) {
            return givenPath.toAbsolutePath().toString();
        }
        return Paths.get("", new String[0]).toAbsolutePath().resolve(givenPath).toString();
    }
}

