/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Keyspace;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.base.Migrator;
import ai.grakn.util.SimpleURI;

public class MigratorBuilder {
    private static final int DEFAULT_RETRIES = 3;
    private static final boolean DEFAULT_FAIL_FAST = true;
    private static final int DEFAULT_MAX_DELAY_MS = 500;
    private static final int DEFAULT_LINES = -1;
    private SimpleURI uri;
    private Keyspace keyspace;
    private MigrationOptions migrationOptions = null;
    private int retries = 3;
    private boolean failFast = true;
    private int maxDelayMs = 500;
    private int lines = -1;

    public MigratorBuilder setUri(SimpleURI uri) {
        this.uri = uri;
        return this;
    }

    public MigratorBuilder setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public MigratorBuilder setMigrationOptions(MigrationOptions migrationOptions) {
        this.migrationOptions = migrationOptions;
        return this;
    }

    public MigratorBuilder setRetries(int retries) {
        this.retries = retries;
        return this;
    }

    public MigratorBuilder setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public MigratorBuilder setLines(int lines) {
        this.lines = lines;
        return this;
    }

    public Migrator build() {
        if (this.migrationOptions != null) {
            this.retries = this.migrationOptions.getRetry();
            this.maxDelayMs = this.migrationOptions.getMaxDelay();
            this.failFast = this.migrationOptions.isDebug();
            this.lines = this.migrationOptions.getLines();
        }
        return new Migrator(this.uri, this.keyspace, this.retries, this.failFast, this.maxDelayMs, this.lines);
    }
}

