/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Keyspace;
import ai.grakn.client.BatchExecutorClient;
import ai.grakn.client.GraknClient;
import ai.grakn.client.GraknClientException;
import ai.grakn.client.QueryResponse;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraknServerException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryParser;
import ai.grakn.util.SimpleURI;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Migrator.class);
    private final QueryParser queryParser = Graql.withoutGraph().infer(false).parser();
    private final SimpleURI uri;
    private final Keyspace keyspace;
    private final int retries;
    private final boolean failFast;
    private final int maxDelayMs;
    private final int maxLines;
    private final MetricRegistry metricRegistry;
    private final ConsoleReporter reporter;
    private final Meter totalMeter;
    private final Meter successMeter;
    private final Timer parseTemplate;

    public Migrator(SimpleURI uri, Keyspace keyspace, int retries, boolean failFast, int maxDelayMs, int maxLines) {
        this.uri = uri;
        this.keyspace = keyspace;
        this.retries = retries;
        this.failFast = failFast;
        this.maxDelayMs = maxDelayMs;
        this.maxLines = maxLines;
        this.metricRegistry = new MetricRegistry();
        this.totalMeter = this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"total"}));
        this.successMeter = this.metricRegistry.meter(MetricRegistry.name(this.getClass(), (String[])new String[]{"success"}));
        this.parseTemplate = this.metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"parse", "template"}));
        this.reporter = ConsoleReporter.forRegistry((MetricRegistry)this.metricRegistry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
    }

    public void print(String template, Stream<Map<String, Object>> data) {
        data.flatMap(d -> this.template(template, (Map<String, Object>)d, false)).forEach(System.out::println);
    }

    public void load(String template, Stream<Map<String, Object>> data) {
        GraknClient graknClient = GraknClient.of((SimpleURI)this.uri);
        AtomicInteger queriesExecuted = new AtomicInteger(0);
        try (BatchExecutorClient loader = BatchExecutorClient.newBuilder().taskClient(graknClient).maxRetries(this.retries).maxDelay(this.maxDelayMs).metricRegistry(this.metricRegistry).build();){
            this.checkKeyspace(graknClient);
            Stream queryStream = data.flatMap(d -> this.template(template, (Map<String, Object>)d, this.failFast));
            if (this.maxLines > -1) {
                queryStream = queryStream.limit(this.maxLines);
            }
            queryStream.forEach(q -> {
                LOG.trace("Adding query {}", q);
                this.totalMeter.mark();
                Observable observable = loader.add(q, this.keyspace, this.failFast);
                this.subscribeToReportOutcome(this.failFast, (Observable<QueryResponse>)observable, queriesExecuted);
            });
        }
        System.out.println("Loaded " + queriesExecuted + " statements");
    }

    private void subscribeToReportOutcome(boolean failFast, Observable<QueryResponse> addObservable, AtomicInteger queriesExecuted) {
        addObservable.subscribe(taskResult -> {
            LOG.trace("Successfully executed: {}", taskResult);
            queriesExecuted.incrementAndGet();
            this.successMeter.mark();
        }, error -> {
            LOG.debug("Error in execution", error);
            if (failFast) {
                throw GraknBackendException.migrationFailure((String)error.getMessage());
            }
        });
    }

    private void checkKeyspace(GraknClient graknClient) {
        try {
            if (!graknClient.keyspace(this.keyspace.getValue()).isPresent()) {
                throw GraknBackendException.noSuchKeyspace((Keyspace)this.keyspace);
            }
        }
        catch (GraknClientException e) {
            throw GraknServerException.internalError((String)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Stream<Query> template(String template, Map<String, Object> data, boolean failFast) {
        try (Timer.Context c = this.parseTemplate.time();){
            Stream stream = this.queryParser.parseTemplate(template, data);
            return stream;
        }
        catch (Exception e) {
            System.out.println("Query not sent to server: " + e.getMessage());
            if (!failFast) return Stream.empty();
            throw e;
        }
    }

    ConsoleReporter getReporter() {
        return this.reporter;
    }
}

