/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base.io;

import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.migration.base.io.MigrationCLI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MigrationOptions {
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private static final String keyspace = properties.getProperty("graphdatabase.default-keyspace");
    private static final String uri = "localhost:4567";
    private int numberOptions;
    protected Options options = new Options();
    protected CommandLine command;

    public MigrationOptions(String[] args) {
        this.options.addOption("v", "verbose", false, "Print counts of migrated data.");
        this.options.addOption("h", "help", false, "Print usage message.");
        this.options.addOption("k", "keyspace", true, "Grakn graph.");
        this.options.addOption("u", "uri", true, "Location of Grakn Engine.");
        this.options.addOption("n", "no", false, "Write to standard out.");
        this.options.addOption("c", "config", true, "Configuration file.");
    }

    public boolean isVerbose() {
        return this.command.hasOption("v");
    }

    public boolean isHelp() {
        return this.command.hasOption("h");
    }

    public boolean isNo() {
        return this.command.hasOption("n");
    }

    public String getKeyspace() {
        return this.command.hasOption("k") ? this.command.getOptionValue("k") : keyspace;
    }

    public String getConfiguration() {
        return this.command.hasOption("c") ? this.command.getOptionValue("c") : null;
    }

    public String getUri() {
        return this.command.hasOption("u") ? this.command.getOptionValue("u") : uri;
    }

    public Options getOptions() {
        return this.options;
    }

    public int getNumberOptions() {
        return this.numberOptions;
    }

    public String getInput() {
        if (!this.command.hasOption("i")) {
            MigrationCLI.die("Data file missing (-i)");
        }
        return this.resolvePath(this.command.getOptionValue("i"));
    }

    public String getTemplate() {
        if (!this.command.hasOption("t")) {
            MigrationCLI.die("Template file missing (-t)");
        }
        return this.resolvePath(this.command.getOptionValue("t"));
    }

    protected <T extends MigrationOptions> T parse(String[] args) {
        try {
            DefaultParser parser = new DefaultParser();
            this.command = parser.parse(this.options, args);
            this.numberOptions = this.command.getOptions().length;
            return (T)this;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private String resolvePath(String path) {
        Path givenPath = Paths.get(path, new String[0]);
        if (givenPath.isAbsolute()) {
            return givenPath.toAbsolutePath().toString();
        }
        return Paths.get("", new String[0]).toAbsolutePath().resolve(givenPath).toString();
    }
}

