/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base.io;

import ai.grakn.GraknGraph;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.loader.LoaderImpl;
import ai.grakn.engine.loader.client.LoaderClient;
import ai.grakn.migration.base.Migrator;
import ai.grakn.migration.base.io.MigrationOptions;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationLoader.class);

    public static Loader getLoader(MigrationOptions options) {
        return options.getUri().equals("localhost:4567") ? new LoaderImpl(options.getKeyspace()) : new LoaderClient(options.getKeyspace(), Collections.singleton(options.getUri()));
    }

    public static void load(GraknGraph graph, Migrator migrator) {
        MigrationLoader.load((Loader)new LoaderImpl(graph.getKeyspace()), migrator);
    }

    public static void load(Loader loader, int batchSize, Migrator migrator) {
        loader.setBatchSize(batchSize);
        MigrationLoader.load(loader, migrator);
    }

    public static void load(Loader loader, Migrator migrator) {
        try {
            migrator.migrate().forEach(arg_0 -> ((Loader)loader).add(arg_0));
        }
        finally {
            loader.waitToFinish();
            LOG.info("Loading finished with status: " + loader.getLoaderState());
        }
    }
}

