/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.exception.GraqlTemplateParsingException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.macro.Macro;
import ai.grakn.migration.base.Migrator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMigrator
implements Migrator {
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMigrator.class);
    private final QueryBuilderImpl queryBuilder = (QueryBuilderImpl)Graql.withoutGraph().infer(false);
    public static final int BATCH_SIZE = 25;

    public AbstractMigrator registerMacro(Macro macro) {
        this.queryBuilder.registerMacro(macro);
        return this;
    }

    protected Optional<InsertQuery> template(String template, Map<String, Object> data) {
        try {
            return Optional.of((InsertQuery)this.queryBuilder.parseTemplate(template, data));
        }
        catch (GraqlTemplateParsingException e) {
            LOG.warn("Query was not sent to loader- " + e.getMessage());
            LOG.warn("See the Grakn engine logs for more detail about loading status and any resulting stacktraces: " + properties.getLogFilePath());
            return Optional.empty();
        }
    }

    protected <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    protected boolean validValue(Object value) {
        return value != null;
    }
}

