/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base.io;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.engine.GraknEngineServer;
import ai.grakn.engine.backgroundtasks.InMemoryTaskManager;
import ai.grakn.engine.loader.Loader;
import ai.grakn.engine.loader.LoaderImpl;
import ai.grakn.engine.loader.client.LoaderClient;
import ai.grakn.engine.util.ConfigProperties;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.exception.ExceptionUtils;

public class MigrationCLI {
    private static final String COULD_NOT_CONNECT = "Could not connect to Grakn Engine. Have you run 'grakn.sh start'?";
    private static final ConfigProperties properties = ConfigProperties.getInstance();
    private Options defaultOptions = new Options();
    private CommandLine cmd;

    private MigrationCLI(String[] args, Options options) {
        this.defaultOptions.addOption("v", "verbose", false, "Print counts of migrated data.");
        this.defaultOptions.addOption("h", "help", false, "Print usage message.");
        this.defaultOptions.addOption("k", "keyspace", true, "Grakn graph.");
        this.defaultOptions.addOption("u", "uri", true, "Location of Grakn Engine.");
        this.defaultOptions.addOption("n", "no", false, "Write to standard out.");
        this.addOptions(options);
        DefaultParser parser = new DefaultParser();
        try {
            this.cmd = parser.parse(this.defaultOptions, args);
        }
        catch (ParseException e) {
            this.die(e.getMessage());
        }
        if (this.cmd.hasOption("h")) {
            this.printHelpMessage();
        }
        if (this.cmd.getOptions().length == 0) {
            this.printHelpMessage();
            throw new IllegalArgumentException("Helping");
        }
        if (this.cmd.getOptions().length == 1 && this.cmd.hasOption("h")) {
            throw new IllegalArgumentException("Helping");
        }
        if (!GraknEngineServer.isRunning()) {
            System.out.println(COULD_NOT_CONNECT);
        }
    }

    public static Optional<MigrationCLI> create(String[] args, Options options) {
        try {
            return Optional.of(new MigrationCLI(args, options));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public void writeToSout(Stream<InsertQuery> queries) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
        queries.map(Object::toString).forEach(str -> {
            try {
                writer.write((String)str);
                writer.write("\n");
            }
            catch (IOException e) {
                this.die("Problem writing");
            }
        });
        try {
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToSout(String string) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(System.out));
        try {
            writer.write(string);
            writer.flush();
        }
        catch (IOException e) {
            this.die("Problem writing");
        }
    }

    public void printInitMessage(String dataToMigrate) {
        System.out.println("Migrating data " + dataToMigrate + " using Grakn Engine " + this.getEngineURI() + " into graph " + this.getKeyspace());
    }

    public void printWholeCompletionMessage() {
        System.out.println("Migration complete.");
        if (this.hasOption("v")) {
            System.out.println("Gathering information about migrated data. If in a hurry, you can ctrl+c now.");
            GraknGraph graph = this.getGraph();
            QueryBuilder qb = graph.graql();
            StringBuilder builder = new StringBuilder();
            builder.append("Graph ontology contains:\n");
            builder.append("\t ").append(graph.admin().getMetaEntityType().instances().size()).append(" entity types\n");
            builder.append("\t ").append(graph.admin().getMetaRelationType().instances().size()).append(" relation types\n");
            builder.append("\t ").append(graph.admin().getMetaRoleType().instances().size()).append(" role types\n");
            builder.append("\t ").append(graph.admin().getMetaResourceType().instances().size()).append(" resource types\n");
            builder.append("\t ").append(graph.admin().getMetaRuleType().instances().size()).append(" rule types\n\n");
            builder.append("Graph data contains:\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.var((String)"y")), Graql.var((String)"y").isa("entity-type")}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" entities\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.var((String)"y")), Graql.var((String)"y").isa("relation-type")}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" relations\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.var((String)"y")), Graql.var((String)"y").isa("resource-type")}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" resources\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.var((String)"y")), Graql.var((String)"y").isa("rule-type")}).select(new String[]{"x"}).distinct().aggregate(Graql.count()).execute()).append(" rules\n\n");
            System.out.println(builder);
            graph.close();
        }
    }

    public void initiateShutdown() {
        System.out.println("Initiating shutdown...");
        InMemoryTaskManager.getInstance().shutdown();
    }

    public String getEngineURI() {
        return this.cmd.getOptionValue("u", "localhost:4567");
    }

    public String getKeyspace() {
        return this.cmd.getOptionValue("k", properties.getProperty("graphdatabase.default-keyspace"));
    }

    public String getOption(String opt) {
        return this.cmd.getOptionValue(opt);
    }

    public String getRequiredOption(String opt, String errorMessage) {
        return this.hasOption(opt) ? this.getOption(opt) : this.die(errorMessage);
    }

    public boolean hasOption(String opt) {
        return this.cmd.hasOption(opt);
    }

    public String fileAsString(File file) {
        try {
            return Files.readLines((File)file, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            this.die("Could not read file " + file.getPath());
            throw new RuntimeException(e);
        }
    }

    public Loader getLoader() {
        return this.getEngineURI().equals("localhost:4567") ? new LoaderImpl(this.getKeyspace()) : new LoaderClient(this.getKeyspace(), Collections.singleton(this.getEngineURI()));
    }

    public GraknGraph getGraph() {
        return Grakn.factory((String)this.getEngineURI(), (String)this.getKeyspace()).getGraph();
    }

    public void addOptions(Options options) {
        options.getOptions().forEach(arg_0 -> ((Options)this.defaultOptions).addOption(arg_0));
    }

    public String die(Throwable throwable) {
        return this.die(ExceptionUtils.getFullStackTrace((Throwable)throwable));
    }

    public String die(String errorMsg) {
        this.printHelpMessage();
        throw new RuntimeException(errorMsg);
    }

    private void printHelpMessage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        PrintWriter printWriter = new PrintWriter(System.out);
        int width = helpFormatter.getWidth();
        int leftPadding = helpFormatter.getLeftPadding();
        int descPadding = helpFormatter.getDescPadding();
        helpFormatter.printHelp(printWriter, width, "migration.sh", null, this.defaultOptions, leftPadding, descPadding, null);
        printWriter.flush();
    }
}

