/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.Grakn;
import ai.grakn.GraknTx;
import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.client.Client;
import ai.grakn.concept.Label;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.base.Migrator;
import ai.grakn.util.Schema;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.HelpFormatter;
import org.yaml.snakeyaml.Yaml;

public class MigrationCLI {
    private static final String COULD_NOT_CONNECT = "Could not connect to Grakn Engine. Have you run 'grakn server start'?";

    public static <T extends MigrationOptions> List<Optional<T>> init(String[] args, Function<String[], T> constructor) {
        MigrationOptions baseOptions = (MigrationOptions)constructor.apply(args);
        if (baseOptions.getConfiguration() != null) {
            return MigrationCLI.extractOptionsFromConfiguration(baseOptions.getConfiguration(), args).stream().map(constructor).map(MigrationCLI::validate).collect(Collectors.toList());
        }
        return Collections.singletonList(MigrationCLI.validate(baseOptions));
    }

    private static <T extends MigrationOptions> Optional<T> validate(T options) {
        if (options.isHelp()) {
            MigrationCLI.printHelpMessage(options);
            return Optional.empty();
        }
        if (options.getNumberOptions() == 0) {
            MigrationCLI.printHelpMessage(options);
            return Optional.empty();
        }
        if (!Client.serverIsRunning((String)options.getUri())) {
            System.err.println(COULD_NOT_CONNECT);
            return Optional.empty();
        }
        return Optional.of(options);
    }

    public static void loadOrPrint(File templateFile, Stream<Map<String, Object>> data, MigrationOptions options) {
        String template = MigrationCLI.fileAsString(templateFile);
        Migrator migrator = Migrator.to(options.getUri(), options.getKeyspace());
        if (options.isNo()) {
            migrator.print(template, data);
        } else {
            MigrationCLI.printInitMessage(options);
            migrator.load(template, data, options.getBatch(), options.getNumberActiveTasks(), options.getRetry(), options.isDebug());
            MigrationCLI.printWholeCompletionMessage(options);
        }
    }

    public static void printInitMessage(MigrationOptions options) {
        System.out.println("Migrating data " + (options.hasInput() ? options.getInput() : "") + " using Grakn Engine " + options.getUri() + " into graph " + options.getKeyspace());
    }

    public static void printWholeCompletionMessage(MigrationOptions options) {
        System.out.println("Migration complete.");
        if (options.isVerbose()) {
            System.out.println("Gathering information about migrated data. If in a hurry, you can ctrl+c now.");
            GraknTx graph = Grakn.session((String)options.getUri(), (Keyspace)options.getKeyspace()).open(GraknTxType.WRITE);
            QueryBuilder qb = graph.graql();
            StringBuilder builder = new StringBuilder();
            builder.append("Graph schema contains:\n");
            builder.append("\t ").append(graph.admin().getMetaEntityType().instances().count()).append(" entity types\n");
            builder.append("\t ").append(graph.admin().getMetaRelationType().instances().count()).append(" relation types\n");
            builder.append("\t ").append(graph.admin().getMetaRole().subs().count()).append(" roles\n\n");
            builder.append("\t ").append(graph.admin().getMetaResourceType().instances().count()).append(" resource types\n");
            builder.append("\t ").append(graph.admin().getMetaRule().subs().count()).append(" rules\n\n");
            builder.append("Graph data contains:\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.label((Label)Schema.MetaSchema.ENTITY.getLabel()))}).aggregate(Graql.count()).execute()).append(" entities\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.label((Label)Schema.MetaSchema.RELATIONSHIP.getLabel()))}).aggregate(Graql.count()).execute()).append(" relations\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.label((Label)Schema.MetaSchema.ATTRIBUTE.getLabel()))}).aggregate(Graql.count()).execute()).append(" resources\n");
            builder.append("\t ").append(qb.match(new Pattern[]{Graql.var((String)"x").isa(Graql.label((Label)Schema.MetaSchema.RULE.getLabel()))}).aggregate(Graql.count()).execute()).append(" rules\n\n");
            System.out.println(builder);
            graph.close();
        }
    }

    private static String fileAsString(File file) {
        try {
            return Files.readLines((File)file, (Charset)StandardCharsets.UTF_8).stream().collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read file " + file.getPath(), e);
        }
    }

    private static void printHelpMessage(MigrationOptions options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, Charset.defaultCharset());
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        int width = helpFormatter.getWidth();
        int leftPadding = helpFormatter.getLeftPadding();
        int descPadding = helpFormatter.getDescPadding();
        helpFormatter.printHelp(printWriter, width, "graql migrate", null, options.getOptions(), leftPadding, descPadding, null);
        printWriter.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String[]> extractOptionsFromConfiguration(String path, String[] args) {
        File configuration = new File(path);
        if (!configuration.exists()) {
            throw new IllegalArgumentException("Could not find configuration file " + path);
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configuration), Charset.defaultCharset());){
            List config = (List)new Yaml().load((Reader)reader);
            ArrayList<String[]> options = new ArrayList<String[]>();
            for (Map c : config) {
                ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(args));
                c.entrySet().stream().flatMap(m -> Stream.of("-" + (String)m.getKey(), (String)m.getValue())).forEach(parameters::add);
                options.add(parameters.toArray(new String[parameters.size()]));
            }
            ArrayList<String[]> arrayList = options;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse configuration file.");
        }
    }
}

