/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.client.LoaderClient;
import ai.grakn.engine.TaskStatus;
import ai.grakn.exception.GraqlTemplateParsingException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.macro.Macro;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final AtomicInteger numberQueriesSubmitted = new AtomicInteger(0);
    private static final AtomicInteger numberBatchesCompleted = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(Migrator.class);
    private final QueryBuilderImpl queryBuilder = (QueryBuilderImpl)Graql.withoutGraph().infer(false);
    public static final int BATCH_SIZE = 25;
    public static final int ACTIVE_TASKS = 25;
    public static final boolean RETRY = false;
    private final String uri;
    private final String keyspace;
    private int batchSize;
    private long startTime;

    private Migrator(String uri, String keyspace) {
        this.uri = uri;
        this.keyspace = keyspace;
    }

    public static Migrator to(String uri, String keyspace) {
        return new Migrator(uri, keyspace);
    }

    public Migrator registerMacro(Macro macro) {
        this.queryBuilder.registerMacro(macro);
        return this;
    }

    public void load(String template, Stream<Map<String, Object>> converter) {
        this.load(template, converter, 25, 25, false);
    }

    public void print(String template, Stream<Map<String, Object>> converter) {
        converter.flatMap(d -> this.template(template, (Map<String, Object>)d).stream()).forEach(System.out::println);
    }

    public void load(String template, Stream<Map<String, Object>> converter, int batchSize, int numberActiveTasks, boolean retry) {
        this.startTime = System.currentTimeMillis();
        this.batchSize = batchSize;
        LoaderClient loader = new LoaderClient(this.keyspace, this.uri, this.recordMigrationStates());
        loader.setBatchSize(batchSize);
        loader.setNumberActiveTasks(numberActiveTasks);
        loader.setRetryPolicy(retry);
        converter.flatMap(d -> this.template(template, (Map<String, Object>)d).stream()).forEach(q -> {
            numberQueriesSubmitted.incrementAndGet();
            loader.add(q);
        });
        loader.waitToFinish();
    }

    protected List<InsertQuery> template(String template, Map<String, Object> data) {
        try {
            return this.queryBuilder.parseTemplate(template, data);
        }
        catch (GraqlTemplateParsingException | IllegalArgumentException e) {
            LOG.warn("Query was not sent to loader- " + e.getMessage());
            LOG.warn("See the Grakn engine logs for more detail about loading status and any resulting stacktraces");
            return Collections.emptyList();
        }
    }

    private Consumer<Json> recordMigrationStates() {
        return json -> {
            TaskStatus status = TaskStatus.valueOf((String)json.at("status").asString());
            Json configuration = Json.read((String)json.at("configuration").asString());
            int batch = configuration.at("batchNumber").asInteger();
            numberBatchesCompleted.incrementAndGet();
            long timeElapsedSeconds = (System.currentTimeMillis() - this.startTime) / 1000L;
            long numberQueriesCompleted = numberBatchesCompleted.get() * this.batchSize;
            LOG.info(String.format("Status of batch [%s]: %s", batch, status));
            LOG.info(String.format("Number queries submitted: %s", numberQueriesSubmitted.get()));
            LOG.info(String.format("Number batches completed: %s", numberBatchesCompleted.get()));
            LOG.info(String.format("~Number queries completed: %s", numberQueriesCompleted));
            LOG.info(String.format("~Rate of completion (queries/second): %s", numberQueriesCompleted / timeElapsedSeconds));
        };
    }
}

