/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.base;

import ai.grakn.client.LoaderClient;
import ai.grakn.engine.TaskStatus;
import ai.grakn.exception.GraqlTemplateParsingException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.internal.query.QueryBuilderImpl;
import ai.grakn.graql.macro.Macro;
import ai.grakn.migration.base.Migrator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import mjson.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMigrator
implements Migrator {
    private static final AtomicInteger numberQueriedSubmitted = new AtomicInteger(0);
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMigrator.class);
    private final QueryBuilderImpl queryBuilder = (QueryBuilderImpl)Graql.withoutGraph().infer(false);
    public static final int BATCH_SIZE = 25;
    public static final int ACTIVE_TASKS = 25;

    public AbstractMigrator registerMacro(Macro macro) {
        this.queryBuilder.registerMacro(macro);
        return this;
    }

    @Override
    public void load(String uri, String keyspace) {
        this.load(uri, keyspace, 25, 25);
    }

    @Override
    public void load(String uri, String keyspace, int batchSize, int numberActiveTasks) {
        LoaderClient loader = new LoaderClient(keyspace, uri, this.recordMigrationStates());
        loader.setBatchSize(batchSize);
        loader.setNumberActiveTasks(numberActiveTasks);
        this.migrate().forEach(q -> {
            numberQueriedSubmitted.incrementAndGet();
            loader.add(q);
        });
        loader.waitToFinish();
    }

    protected Optional<InsertQuery> template(String template, Map<String, Object> data) {
        try {
            return Optional.of(this.queryBuilder.parseTemplate(template, data));
        }
        catch (GraqlTemplateParsingException e) {
            LOG.warn("Query was not sent to loader- " + e.getMessage());
            LOG.warn("See the Grakn engine logs for more detail about loading status and any resulting stacktraces");
            return Optional.empty();
        }
    }

    protected <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    protected boolean validValue(Object value) {
        return value != null;
    }

    private Consumer<Json> recordMigrationStates() {
        return json -> {
            TaskStatus status = TaskStatus.valueOf((String)json.at("status").asString());
            Json configuration = Json.read((String)json.at("configuration").asString());
            int batchNumber = configuration.at("batchNumber").asInteger();
            LOG.info("Status of finished batch: " + status);
            LOG.info("Batches finished: " + batchNumber);
            LOG.info("Number Queries finished: " + numberQueriedSubmitted.get());
        };
    }
}

