/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kgms.remote;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.remote.RemoteGraknSession;
import ai.grakn.remote.RemoteGraknTx;
import ai.grakn.rpc.generated.GrpcGrakn;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.SimpleURI;
import io.grpc.ManagedChannel;

public class GraknKGMSRemoteSession
extends RemoteGraknSession {
    private final String username;
    private final String password;

    private GraknKGMSRemoteSession(Keyspace keyspace, SimpleURI uri, ManagedChannel channel, String username, String password) {
        super(keyspace, uri, channel);
        this.username = username;
        this.password = password;
    }

    public static GraknKGMSRemoteSession create(Keyspace keyspace, SimpleURI uri, ManagedChannel channel, String username, String password) {
        return new GraknKGMSRemoteSession(keyspace, uri, channel, username, password);
    }

    public RemoteGraknTx open(GraknTxType transactionType) {
        GrpcGrakn.TxRequest request = this.buildRequest(transactionType);
        return RemoteGraknTx.create((RemoteGraknSession)this, (GrpcGrakn.TxRequest)request);
    }

    private GrpcGrakn.TxRequest buildRequest(GraknTxType txType) {
        GrpcGrakn.Open open = GrpcGrakn.Open.newBuilder().setKeyspace(GrpcGrakn.Keyspace.newBuilder().setValue(this.keyspace().getValue())).setTxType(GraknKGMSRemoteSession.convert(txType)).setUsername(this.username).setPassword(this.password).build();
        return GrpcGrakn.TxRequest.newBuilder().setOpen(open).build();
    }

    private static GrpcGrakn.TxType convert(GraknTxType txType) {
        switch (txType) {
            case READ: {
                return GrpcGrakn.TxType.Read;
            }
            case WRITE: {
                return GrpcGrakn.TxType.Write;
            }
            case BATCH: {
                return GrpcGrakn.TxType.Batch;
            }
        }
        throw CommonUtil.unreachableStatement((String)("Unrecognised " + txType));
    }
}

