/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kgms;

import ai.grakn.GraknConfigKey;
import ai.grakn.engine.GraknConfig;
import ai.grakn.kgms.authentication.service.SignedToken;
import ai.grakn.kgms.console.AuthenticatedCommand;
import ai.grakn.kgms.console.AuthenticatedCommandBus;
import ai.grakn.kgms.console.AuthenticatedCommandBusImpl;
import ai.grakn.kgms.console.NotRecognized;
import ai.grakn.kgms.console.PrintWriterNotRecognised;
import ai.grakn.kgms.console.authentication.createuser.CreateUserCommand;
import ai.grakn.kgms.console.authentication.createuser.CreateUserDisplay;
import ai.grakn.kgms.console.authentication.deleteuser.DeleteUserCommand;
import ai.grakn.kgms.console.authentication.deleteuser.DeleteUserDisplay;
import ai.grakn.kgms.console.authentication.retrieveallusers.RetrieveAllUserCommand;
import ai.grakn.kgms.console.authentication.retrieveallusers.RetrieveAllUserDisplay;
import ai.grakn.kgms.console.authentication.retrieveuser.RetrieveUserCommand;
import ai.grakn.kgms.console.authentication.retrieveuser.RetrieveUserDisplay;
import ai.grakn.kgms.console.authentication.updateuser.UpdateUserCommand;
import ai.grakn.kgms.console.authentication.updateuser.UpdateUserDisplay;
import ai.grakn.kgms.rpc.GrpcClient;
import ai.grakn.util.SimpleURI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import javax.annotation.Nullable;
import jline.console.ConsoleReader;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KGMSClientShell {
    private static final Logger LOG = LoggerFactory.getLogger(KGMSClientShell.class);
    private static final GraknConfigKey<Path> KGMS_TRUST_STORE_PATH = GraknConfigKey.key((String)"kgms.client.trust-store", (GraknConfigKey.KeyParser)GraknConfigKey.PATH);
    private static final String PROMPT = ">>> ";
    private SignedToken authToken;
    private PrintWriter outPrinter;
    private final ConsoleReader console;
    private final GrpcClient grpcClient;
    private final AuthenticatedCommandBus commandBus;

    public static void main(String[] args) {
        int exitCode = KGMSClientShell.startShell(args, System.in, System.out, GraknConfig.create()) ? 0 : 1;
        System.exit(exitCode);
    }

    public static boolean startShell(String[] args, InputStream in, OutputStream out, GraknConfig config) {
        Options options = new Options();
        options.addOption("u", "username", true, "username of admin user");
        options.addOption("p", "password", true, "password of admin user");
        options.addOption("c", "contact-point", true, "contact point for gRPC server");
        DefaultParser parser = new DefaultParser();
        try {
            int grpcPort;
            String grpcHost;
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption('c')) {
                SimpleURI contactPoint = new SimpleURI(cmd.getOptionValue('c'));
                grpcHost = contactPoint.getHost();
                grpcPort = contactPoint.getPort();
            } else {
                grpcHost = (String)config.getProperty(GraknConfigKey.SERVER_HOST_NAME);
                grpcPort = (Integer)config.getProperty(GraknConfigKey.GRPC_PORT);
            }
            GrpcClient grpcClient = new GrpcClient(grpcHost, grpcPort, (Path)config.getProperty(KGMS_TRUST_STORE_PATH));
            KGMSClientShell shell = new KGMSClientShell(in, out, grpcClient);
            String username = cmd.getOptionValue('u');
            String password = cmd.getOptionValue('p');
            shell.start(username, password);
        }
        catch (IOException | ParseException e) {
            LOG.error("Unable to start KGMS console", e);
            return false;
        }
        return true;
    }

    KGMSClientShell(InputStream in, OutputStream out, GrpcClient grpcClient) throws IOException {
        this.console = new ConsoleReader(in, out);
        this.outPrinter = new PrintWriter(this.console.getOutput());
        this.grpcClient = grpcClient;
        this.commandBus = this.initialiseCommandBus();
    }

    void start(@Nullable String username, @Nullable String password) throws IOException {
        if (username == null) {
            username = this.console.readLine("Username: ");
        }
        if (password == null) {
            password = this.console.readLine("Password: ", Character.valueOf('*'));
        }
        this.authToken = this.grpcClient.authenticateUser(username, password);
        this.authenticatedShell();
    }

    private void authenticatedShell() throws IOException {
        String line;
        this.console.setPrompt(PROMPT);
        while ((line = this.console.readLine()) != null) {
            this.commandBus.run(line, this.authToken);
        }
    }

    private AuthenticatedCommandBus initialiseCommandBus() {
        return new AuthenticatedCommandBusImpl((NotRecognized)new PrintWriterNotRecognised(this.outPrinter), new AuthenticatedCommand[]{new CreateUserCommand(this.grpcClient.createNewUser(), new CreateUserDisplay(this.outPrinter)), new RetrieveAllUserCommand(this.grpcClient.retrieveAllUser(), new RetrieveAllUserDisplay(this.outPrinter)), new DeleteUserCommand(this.grpcClient.deleteUser(), new DeleteUserDisplay(this.outPrinter)), new RetrieveUserCommand(this.grpcClient.retrieveUser(), new RetrieveUserDisplay(this.outPrinter)), new UpdateUserCommand(this.grpcClient.updateUser(), new UpdateUserDisplay(this.outPrinter))});
    }
}

