package ai.grakn.kgms.rpc;

import ai.grakn.kgms.authentication.model.User;
import ai.grakn.kgms.authentication.service.SignedToken;
import ai.grakn.kgms.authentication.usecase.UseCaseReq;
import ai.grakn.kgms.authentication.usecase.UseCaseReqResp;
import ai.grakn.kgms.authentication.usecase.createuser.CreateNewUserRequest;
import ai.grakn.kgms.authentication.usecase.deleteuser.DeleteUserRequest;
import ai.grakn.kgms.authentication.usecase.retrieveallusers.RetrieveAllUserRequest;
import ai.grakn.kgms.authentication.usecase.retrieveuser.RetrieveUserRequest;
import ai.grakn.kgms.authentication.usecase.updateuser.UpdateUserRequest;
import ai.grakn.kgms.rpc.generated.KGMSConsoleAuthGrpc;
import ai.grakn.kgms.rpc.generated.KGMSConsoleAuthGrpc.KGMSConsoleAuthBlockingStub;
import ai.grakn.kgms.rpc.generated.KGMSConsoleAuthProto;
import ai.grakn.kgms.rpc.generated.KGMSConsoleAuthProto.AuthenticatedRequest;
import io.grpc.Channel;
import io.grpc.ManagedChannelBuilder;

import javax.net.ssl.SSLException;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Class that provides interfaces to gRPC usecases
 *
 * @author Marco Scoppetta
 */

public class GrpcClient {

    private final Channel channel;
    private final KGMSConsoleAuthBlockingStub stub;


    public GrpcClient(String host, int port, Path trustCertPath) throws SSLException {
        File trustedCert = new File(trustCertPath.toString());
        System.out.println(trustedCert);
        channel = ManagedChannelBuilder
                .forAddress(host, port)
                .usePlaintext(true)
                .build();
        stub = KGMSConsoleAuthGrpc.newBlockingStub(channel);
    }

    public SignedToken authenticateUser(String username, String password) {
        KGMSConsoleAuthProto.User userRequest = KGMSConsoleAuthProto.User.newBuilder()
                .setUsername(username)
                .setPassword(password).build();
        return new SignedToken(stub.authenticateUser(userRequest).getToken());
    }


    public UseCaseReqResp<CreateNewUserRequest, User> createNewUser() {
        return (req, token) -> {
            KGMSConsoleAuthProto.User userRequest = KGMSConsoleAuthProto.User.newBuilder()
                    .setUsername(req.username)
                    .setPassword(req.password)
                    .setRole(req.role).build();
            // cc coun ter stit counte () {
            //


            AuthenticatedRequest authRequest = AuthenticatedRequest.newBuilder()
                    .setUser(userRequest)
                    .setToken(token.token).build();
            stub.createUser(authRequest);
            return new User(req.username, req.password, req.role);
        };
    }

    public UseCaseReqResp<RetrieveAllUserRequest, List<User>> retrieveAllUser() {
        return (req, token) -> {
            AuthenticatedRequest authRequest = AuthenticatedRequest.newBuilder()
                    .setToken(token.token).build();
            return stub.retrieveAllUsers(authRequest).getUsersList().stream()
                    .map(user -> new User(user.getUsername(), user.getPassword(), user.getRole()))
                    .collect(Collectors.toList());
        };
    }

    public UseCaseReqResp<RetrieveUserRequest, User> retrieveUser() {
        return (req, token) -> {
            KGMSConsoleAuthProto.User userRequest = KGMSConsoleAuthProto.User.newBuilder()
                    .setUsername(req.username)
                    .build();
            AuthenticatedRequest authRequest = AuthenticatedRequest.newBuilder()
                    .setUser(userRequest)
                    .setToken(token.token).build();
            KGMSConsoleAuthProto.User retrievedUser = stub.retrieveUser(authRequest);
            return new User(retrievedUser.getUsername(), null, retrievedUser.getRole());
        };
    }

    public UseCaseReq<DeleteUserRequest> deleteUser() {
        return (req, token) -> {
            KGMSConsoleAuthProto.User userRequest = KGMSConsoleAuthProto.User.newBuilder()
                    .setUsername(req.username)
                    .build();
            AuthenticatedRequest authRequest = AuthenticatedRequest.newBuilder()
                    .setUser(userRequest)
                    .setToken(token.token).build();
            stub.deleteUser(authRequest);
        };
    }

    public UseCaseReqResp<UpdateUserRequest, User> updateUser() {
        return (req, token) -> {
            KGMSConsoleAuthProto.User.Builder userRequest = KGMSConsoleAuthProto.User.newBuilder().setUsername(req.username());
            if (req.password() != null) userRequest.setPassword(req.password());
            if (req.role() != null) userRequest.setRole(req.role());

            AuthenticatedRequest authRequest = AuthenticatedRequest.newBuilder()
                    .setUser(userRequest.build())
                    .setToken(token.token).build();
            stub.updateUser(authRequest);
            return new User(req.username(), req.password(), req.role());
        };
    }
}
