package ai.grakn.kgms.remote;

import ai.grakn.Keyspace;
import ai.grakn.remote.RemoteGraknSession;
import ai.grakn.util.SimpleURI;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;

import java.nio.file.Path;

public class RemoteKGMS {
    private RemoteKGMS() {
    }

    public static RemoteGraknSession session(SimpleURI uri, Path trustedCertPath, Keyspace keyspace, String username, String password) {
//        File trustedCert = new File(trustedCertPath.toString());
        ManagedChannel channel = ManagedChannelBuilder
                        .forAddress(uri.getHost(), uri.getPort())
                        .usePlaintext(true)
                        .build();
        return GraknKGMSRemoteSession.create(keyspace, uri, channel, username, password);

    }
}
