package ai.grakn.kgms.remote;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.remote.RemoteGraknSession;
import ai.grakn.remote.RemoteGraknTx;
import ai.grakn.rpc.generated.GrpcGrakn;
import ai.grakn.rpc.generated.GrpcGrakn.TxRequest;
import ai.grakn.rpc.generated.GrpcGrakn.TxType;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.SimpleURI;
import io.grpc.ManagedChannel;

public class GraknKGMSRemoteSession extends RemoteGraknSession {
    private final String username;
    private final String password;

    private GraknKGMSRemoteSession(Keyspace keyspace, SimpleURI uri, ManagedChannel channel, String username, String password) {
        super(keyspace, uri, channel);
        this.username = username;
        this.password = password;
    }

    public static GraknKGMSRemoteSession create(Keyspace keyspace, SimpleURI uri, ManagedChannel channel, String username, String password) {
        return new GraknKGMSRemoteSession(keyspace, uri, channel, username, password);
    }

    @Override
    public RemoteGraknTx open(GraknTxType transactionType) {
        TxRequest request = buildRequest(transactionType);
        return RemoteGraknTx.create(this, request);
    }

    private TxRequest buildRequest(GraknTxType txType) {
         GrpcGrakn.Open open = GrpcGrakn.Open.newBuilder()
                .setKeyspace(GrpcGrakn.Keyspace.newBuilder().setValue(keyspace().getValue()))
                .setTxType(convert(txType))
                .setUsername(username)
                .setPassword(password)
                .build();
         return TxRequest.newBuilder().setOpen(open).build();
    }


    //TODO: make this convert method public in opensource version so that we can re-use it here.
    private static TxType convert(GraknTxType txType) {
        switch (txType) {
            case READ:
                return TxType.Read;
            case WRITE:
                return TxType.Write;
            case BATCH:
                return TxType.Batch;
            default:
                throw CommonUtil.unreachableStatement("Unrecognised " + txType);
        }
    }

}
