/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.basicmodelzoo.cv.object_detection.ssd;

import ai.djl.Model;
import ai.djl.basicmodelzoo.cv.object_detection.ssd.SingleShotDetection;
import ai.djl.nn.Block;
import ai.djl.nn.BlockFactory;
import ai.djl.nn.SequentialBlock;
import ai.djl.translate.ArgumentsUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SsdBlockFactory
implements BlockFactory {
    private static final long serialVersionUID = 1L;

    public Block newBlock(Model model, Path modelPath, Map<String, ?> arguments) {
        int numClasses = ArgumentsUtil.intValue(arguments, (String)"outSize");
        int numFeatures = ArgumentsUtil.intValue(arguments, (String)"numFeatures");
        boolean globalPool = ArgumentsUtil.booleanValue(arguments, (String)"globalPool");
        int[] numFilters = ((List)arguments.get("numFilters")).stream().mapToInt(Double::intValue).toArray();
        List ratio = ((List)arguments.get("ratios")).stream().map(Double::floatValue).collect(Collectors.toList());
        List<List<Float>> sizes = ((List)arguments.get("sizes")).stream().map(size -> size.stream().map(Double::floatValue).collect(Collectors.toList())).collect(Collectors.toList());
        ArrayList<List<Float>> ratios = new ArrayList<List<Float>>();
        for (int i = 0; i < 5; ++i) {
            ratios.add(ratio);
        }
        SequentialBlock baseBlock = new SequentialBlock();
        for (int numFilter : numFilters) {
            baseBlock.add((Block)SingleShotDetection.getDownSamplingBlock(numFilter));
        }
        return SingleShotDetection.builder().setNumClasses(numClasses).setNumFeatures(numFeatures).optGlobalPool(globalPool).setRatios(ratios).setSizes(sizes).setBaseNetwork((Block)baseBlock).build();
    }
}

