/*
 * Decompiled with CFR 0.152.
 */
package ae.teletronics.solr.plugin;

import java.net.URL;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.util.plugin.SolrCoreAware;

public class ThreadRenamingRequestHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static ConcurrentMap<Thread, String> executingThreads = new ConcurrentHashMap<Thread, String>();
    private String delegateName;
    private SolrRequestHandler delegate;

    public void init(NamedList initArgs) {
        this.delegateName = String.valueOf(initArgs.get("delegate"));
    }

    public void inform(SolrCore core) {
        this.delegate = core.getRequestHandler(this.delegateName);
        if (this.delegate == null) {
            throw new IllegalArgumentException("Solr request handler delegate not found! Please check your <str name=\"delegate\">...</str> init argument");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequestBody(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        Thread thread = Thread.currentThread();
        String originalThreadName = thread.getName();
        try {
            try {
                executingThreads.put(thread, originalThreadName);
                thread.setName(String.format("%s (Start: %s): %s", this.delegate.getName(), DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.now()), SolrParams.toMap((NamedList)solrQueryRequest.getParams().toNamedList()).toString()));
            }
            catch (NullPointerException | SecurityException runtimeException) {
                // empty catch block
            }
            this.delegate.handleRequest(solrQueryRequest, solrQueryResponse);
        }
        finally {
            executingThreads.remove(thread);
            try {
                thread.setName(originalThreadName);
            }
            catch (SecurityException securityException) {}
        }
    }

    public static int getRunningRequestCount() {
        return executingThreads.size();
    }

    public static List<String> getRunningRequests() {
        return executingThreads.keySet().stream().map(Thread::getName).collect(Collectors.toList());
    }

    public String getName() {
        return "ThreadRenamingRequestHandlerDelegate";
    }

    public String getVersion() {
        return "1.0";
    }

    public String getDescription() {
        return "Thread renaming request handler delegate";
    }

    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }

    public String getSource() {
        return null;
    }

    public URL[] getDocs() {
        return new URL[0];
    }

    public NamedList getStatistics() {
        SimpleOrderedMap result = new SimpleOrderedMap();
        executingThreads.forEach((arg_0, arg_1) -> ThreadRenamingRequestHandler.lambda$getStatistics$0((NamedList)result, arg_0, arg_1));
        return result;
    }

    private static /* synthetic */ void lambda$getStatistics$0(NamedList result, Thread thread, String originalThreadName) {
        String currentName = thread.getName();
        if (!currentName.equals(originalThreadName)) {
            result.add(originalThreadName, (Object)currentName);
        }
    }
}

