/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect.opt;

import com.sun.xml.bind.Util;
import com.sun.xml.bind.v2.bytecode.ClassTailor;
import com.sun.xml.bind.v2.runtime.reflect.opt.Injector;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AccessorInjector {
    private static final Logger logger = Util.getClassLogger();
    protected static final boolean noOptimize;

    AccessorInjector() {
    }

    public static final Class<?> prepare(Class beanClass, String templateClassName, String newClassName, String ... replacements) {
        if (noOptimize) {
            return null;
        }
        try {
            ClassLoader cl = beanClass.getClassLoader();
            if (cl == null) {
                return null;
            }
            Class c = Injector.find(cl, newClassName);
            if (c == null) {
                byte[] image = AccessorInjector.tailor(templateClassName, newClassName, replacements);
                if (image == null) {
                    return null;
                }
                c = Injector.inject(cl, newClassName, image);
            }
            return c;
        }
        catch (SecurityException e) {
            logger.log(Level.INFO, "Unable to create an optimized TransducedAccessor ", e);
            return null;
        }
    }

    private static final byte[] tailor(String templateClassName, String newClassName, String ... replacements) {
        InputStream resource = AccessorInjector.class.getClassLoader().getResourceAsStream(templateClassName + ".class");
        if (resource == null) {
            return null;
        }
        return ClassTailor.tailor(resource, templateClassName, newClassName, replacements);
    }

    static {
        boolean bl = noOptimize = Util.getSystemProperty(ClassTailor.class.getName() + ".noOptimize") != null;
        if (noOptimize) {
            logger.info("The optimized code generation is disabled");
        }
    }
}

