/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.v2.runtime.reflect;

import com.sun.xml.bind.api.AccessorException;
import com.sun.xml.bind.v2.model.core.ID;
import com.sun.xml.bind.v2.model.runtime.RuntimePropertyInfo;
import com.sun.xml.bind.v2.runtime.IDHandler;
import com.sun.xml.bind.v2.runtime.Name;
import com.sun.xml.bind.v2.runtime.Transducer;
import com.sun.xml.bind.v2.runtime.UnmarshallingContext;
import com.sun.xml.bind.v2.runtime.XMLSerializer;
import com.sun.xml.bind.v2.runtime.reflect.Accessor;
import com.sun.xml.bind.v2.runtime.reflect.opt.OptimizedTransducedAccessorFactory;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransducedAccessor<BeanT> {
    public boolean useNamespace() {
        return false;
    }

    public void declareNamespace(BeanT o, XMLSerializer w) throws AccessorException, SAXException {
    }

    public abstract String print(BeanT var1, XMLSerializer var2) throws AccessorException, SAXException;

    public abstract void parse(BeanT var1, CharSequence var2, UnmarshallingContext var3) throws AccessorException, SAXException;

    public abstract boolean hasValue(BeanT var1) throws AccessorException;

    public static TransducedAccessor get(RuntimePropertyInfo prop, Transducer xducer) {
        TransducedAccessor xa;
        assert (!prop.isCollection());
        if (prop.id() == ID.ID) {
            xducer = new IDHandler.ID(xducer);
        } else if (xducer.isDefault() && (xa = OptimizedTransducedAccessorFactory.get(prop)) != null) {
            return xa;
        }
        if (xducer.useNamespace()) {
            return new DefaultContextDependentTransducedAccessorImpl(xducer, prop.getAccessor());
        }
        return new DefaultTransducedAccessorImpl(xducer, prop.getAccessor());
    }

    public void writeLeafElement(BeanT o, Name tagName, String fieldName, XMLSerializer w) throws SAXException, AccessorException, IOException, XMLStreamException {
        assert (!this.useNamespace());
        w.leafElement(tagName, this.print(o, w), fieldName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultTransducedAccessorImpl<BeanT>
    extends TransducedAccessor<BeanT> {
        protected final Transducer xducer;
        protected final Accessor acc;

        public DefaultTransducedAccessorImpl(Transducer xducer, Accessor acc) {
            this.xducer = xducer;
            this.acc = acc.optimize();
        }

        @Override
        public String print(BeanT bean, XMLSerializer w) throws AccessorException {
            return this.xducer.print(this.acc.get(bean), w);
        }

        @Override
        public void parse(BeanT bean, CharSequence lexical, UnmarshallingContext ctxt) throws AccessorException, SAXException {
            this.acc.set(bean, this.xducer.parse(lexical, ctxt));
        }

        @Override
        public boolean hasValue(BeanT bean) throws AccessorException {
            return this.acc.get(bean) != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultContextDependentTransducedAccessorImpl<BeanT>
    extends DefaultTransducedAccessorImpl<BeanT> {
        public DefaultContextDependentTransducedAccessorImpl(Transducer xducer, Accessor acc) {
            super(xducer, acc);
            assert (xducer.useNamespace());
        }

        @Override
        public boolean useNamespace() {
            return true;
        }

        @Override
        public void declareNamespace(BeanT bean, XMLSerializer w) throws AccessorException {
            this.xducer.declareNamespace(this.acc.get(bean), w);
        }

        @Override
        public void writeLeafElement(BeanT o, Name tagName, String fieldName, XMLSerializer w) throws SAXException, AccessorException, IOException, XMLStreamException {
            w.startElement(tagName, null);
            this.declareNamespace(o, w);
            w.endNamespaceDecls();
            w.endAttributes();
            w.text(this.print(o, w), fieldName);
            w.endElement();
        }
    }
}

